/*
 * Decompiled with CFR 0.152.
 */
package worm;

import worm.Playground;
import worm.Point;

class Worm {
    private Point[] wormArray;
    private int nominalLength;
    private int direction;
    private int wormID;
    static final int UP = 0;
    static final int RIGHT = 1;
    static final int DOWN = 2;
    static final int LEFT = 3;
    static final int TO_RIGHT = 1;
    static final int TO_LEFT = 3;

    Worm(int n, Point point, int n2) {
        this.wormID = n;
        this.wormArray = new Point[1];
        this.wormArray[0] = point;
        this.nominalLength = n2;
        this.direction = 5;
        Playground.setWorm(point, n);
    }

    void grow(int n) {
        this.nominalLength += n;
    }

    private void moveTo(Point point) {
        Point[] pointArray = this.wormArray;
        if (this.wormArray.length < this.nominalLength) {
            this.wormArray = new Point[this.wormArray.length + 1];
            System.arraycopy(pointArray, 0, this.wormArray, 1, pointArray.length);
            this.wormArray[0] = point;
            Playground.setWorm(point, this.wormID);
        } else {
            Playground.clearElement(this.wormArray[this.wormArray.length - 1]);
            System.arraycopy(pointArray, 0, this.wormArray, 1, pointArray.length - 1);
            this.wormArray[0] = point;
            Playground.setWorm(point, this.wormID);
        }
    }

    void changeDirection(int n) {
        if ((this.direction + n) % 2 != 0 || this.direction == 5) {
            this.direction = n;
        }
    }

    void changeDirectionTo(int n) {
        this.direction = (this.direction + n) % 4;
    }

    int checkNextFieldAndMove() {
        switch (this.direction) {
            case 0: {
                int n = Playground.field[this.wormArray[0].x][this.wormArray[0].y - 1];
                if (n < 2) {
                    Point point = new Point(this.wormArray[0].x, this.wormArray[0].y - 1);
                    this.moveTo(point);
                }
                return n;
            }
            case 2: {
                int n = Playground.field[this.wormArray[0].x][this.wormArray[0].y + 1];
                if (n < 2) {
                    Point point = new Point(this.wormArray[0].x, this.wormArray[0].y + 1);
                    this.moveTo(point);
                }
                return n;
            }
            case 3: {
                int n = Playground.field[this.wormArray[0].x - 1][this.wormArray[0].y];
                if (n < 2) {
                    Point point = new Point(this.wormArray[0].x - 1, this.wormArray[0].y);
                    this.moveTo(point);
                }
                return n;
            }
            case 1: {
                int n = Playground.field[this.wormArray[0].x + 1][this.wormArray[0].y];
                if (n < 2) {
                    Point point = new Point(this.wormArray[0].x + 1, this.wormArray[0].y);
                    this.moveTo(point);
                }
                return n;
            }
        }
        return 0;
    }
}

