/*
 * Decompiled with CFR 0.152.
 */
package worm;

import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import worm.GameEnging;
import worm.Playground;
import worm.Snake;
import worm.WormText;

class SnakeCanvas
extends Canvas {
    private static Graphics g;
    private Thread engineThread;

    public SnakeCanvas() {
        Snake.GAME_HEIGHT = super.getHeight() - 15;
        Snake.GAME_WIDTH = super.getWidth();
        Snake.state = 0;
        Snake.gameOver = false;
        Snake.lives = 5;
        Snake.score = 0;
        Snake.mayChangeDirection = false;
    }

    public void clearScreen() {
        int n = g.getColor();
        g.setColor(255, 255, 255);
        g.fillRect(0, 0, super.getWidth(), super.getHeight());
        g.setColor(n);
    }

    public void paint(Graphics graphics) {
        if (Snake.state == 3) {
            Playground.drawAllElements();
            SnakeCanvas.displayStatus();
        }
        g = graphics;
    }

    public void hideNotify() {
        if (Snake.state == 4) {
            Snake.state = 3;
        }
    }

    public void showNotify() {
    }

    public void keyPressed(int n) {
        int n2 = this.getGameAction(n);
        if (Snake.state == 2 || Snake.state == 0) {
            // empty if block
        }
        if (Snake.state == 1) {
            Snake.state = 2;
        }
        if (Snake.state == 3) {
            Snake.state = 4;
        }
        if (Snake.state == 4 && Snake.mayChangeDirection) {
            switch (n2) {
                case 1: {
                    Snake.mayChangeDirection = false;
                    Snake.worm.changeDirection(0);
                    break;
                }
                case 5: {
                    Snake.mayChangeDirection = false;
                    Snake.worm.changeDirection(1);
                    break;
                }
                case 6: {
                    Snake.mayChangeDirection = false;
                    Snake.worm.changeDirection(2);
                    break;
                }
                case 2: {
                    Snake.mayChangeDirection = false;
                    Snake.worm.changeDirection(3);
                    break;
                }
                case 9: {
                    Snake.mayChangeDirection = false;
                    Snake.worm.changeDirectionTo(3);
                    break;
                }
                case 11: {
                    Snake.mayChangeDirection = false;
                    Snake.worm.changeDirectionTo(1);
                }
            }
        }
        if (Snake.state == 4 && Snake.mayChangeDirection) {
            switch (n) {
                case 53: {
                    Snake.state = 3;
                    break;
                }
                case 50: {
                    Snake.mayChangeDirection = false;
                    Snake.worm.changeDirection(0);
                    break;
                }
                case 54: {
                    Snake.mayChangeDirection = false;
                    Snake.worm.changeDirection(1);
                    break;
                }
                case 56: {
                    Snake.mayChangeDirection = false;
                    Snake.worm.changeDirection(2);
                    break;
                }
                case 52: {
                    Snake.mayChangeDirection = false;
                    Snake.worm.changeDirection(3);
                }
            }
        }
    }

    public void run(Snake snake) {
        GameEnging gameEnging = new GameEnging(g, snake, this);
        this.engineThread = new Thread(gameEnging);
        this.engineThread.setPriority(10);
        this.engineThread.start();
    }

    public void displayGoodByeScreen() {
        Font font = Font.getFont((int)64, (int)0, (int)8);
        Font font2 = Font.getFont((int)64, (int)1, (int)0);
        String string = "\nGOODBYE";
        String string2 = "\n\nPlease wait!";
        String string3 = "\n\n\n\nSaving data";
        this.clearScreen();
        g.setFont(font2);
        g.drawString(string, super.getWidth() / 2, 0, 17);
        g.setFont(font);
        g.drawString(string2, super.getWidth() / 2, font2.getHeight() * 110 / 100, 17);
        g.setFont(font);
        g.drawString(string3, super.getWidth() / 2, font2.getHeight() * 110 / 100, 17);
    }

    static void displayStatus() {
        String string = WormText.getText(WormText.LANGUAGE, 18) + Integer.toString(Snake.score) + WormText.getText(WormText.LANGUAGE, 17) + Integer.toString(Snake.lives);
        g.drawString(string, (Snake.GAME_WIDTH - Playground.g.getFont().stringWidth(string)) / 2, Snake.GAME_HEIGHT, 20);
    }

    public void displayScores() {
        String string = WormText.getText(WormText.LANGUAGE, 18) + Integer.toString(Snake.score);
        g.drawString(string, super.getWidth() / 2, super.getHeight() / 2, 3);
    }
}

