/*
 * Decompiled with CFR 0.152.
 */
package worm;

import com.siemens.mp.game.Light;
import com.siemens.mp.game.Sound;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Random;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreNotFoundException;
import worm.Backable;
import worm.LanguageSelect;
import worm.Playground;
import worm.ShowHelp;
import worm.ShowInfo;
import worm.Snake$GameOver;
import worm.Snake$InitGame;
import worm.Snake$ShowHighScore;
import worm.SnakeCanvas;
import worm.WelcomeCanvas;
import worm.Worm;
import worm.WormText;

public class Snake
extends MIDlet
implements Runnable,
CommandListener,
Backable {
    static Playground playground;
    private static Snake instance;
    private static Random rand;
    static Worm worm;
    static int INITIAL_LENGTH;
    static final int DELAY = 100;
    static int GROWTH_RATE;
    static final int INITIAL_LIVES = 5;
    static final int FOOD_PIECES = 10;
    static final int INIT = 0;
    static final int WAIT_FOR_KEY = 1;
    static final int IDLE = 2;
    static final int PAUSED = 3;
    static final int PLAY = 4;
    static int state;
    static boolean gameOver;
    static boolean allEaten;
    static int lives;
    static int score;
    static boolean mayChangeDirection;
    static boolean newHighScore;
    static boolean insidegame;
    static boolean datatosave;
    static boolean vibrator;
    static boolean sound;
    private static Snake snake;
    static final int STATUS_HEIGHT = 12;
    static int GAME_HEIGHT;
    static int GAME_WIDTH;
    static Display display;
    static Sound gameSound;
    static final int STOP = 1;
    static final int DIED = 2;
    static final int HIGHSCORE = 3;
    static final int EATEN = 4;
    static int[][] stopSound;
    static int[][] diedSound;
    static int[][] highscoreSound;
    static int[][] eatenSound;
    ShowInfo showinformation;
    ShowHelp showhelpinfo;
    Snake$GameOver gameoverinfo;
    Snake$ShowHighScore highscoreinfo;
    LanguageSelect languageselect;
    static String RSname;
    static RecordStore recordscore;
    static String nameval;
    static int scoreval;
    static int languageval;
    static byte[] scoredata;
    static byte[] namedata;
    static byte[] languagedata;
    static byte[] vibdata;
    static byte[] sounddata;
    static int nameid;
    static int scoreid;
    static int languageid;
    static int vibid;
    static int soundid;
    static Command exitCommand;
    static Command infoCommand;
    static Command helpCommand;
    static Command backCommand;
    static Command scoreCommand;
    static Command languageCommand;
    static Command newgameCommand;
    static Command vibOffCommand;
    static Command vibOnCommand;
    static Command soundOffCommand;
    static Command soundOnCommand;
    static SnakeCanvas canvas;
    static WelcomeCanvas welcomeCanvas;

    static int randomInt() {
        return Math.abs(rand.nextInt());
    }

    public Snake() {
        instance = this;
    }

    public static void main(String[] stringArray) {
        snake = new Snake();
        snake.startApp();
    }

    static Snake getInstance() {
        return instance;
    }

    static void setMenuLanguage() {
        canvas.removeCommand(languageCommand);
        canvas.removeCommand(exitCommand);
        canvas.removeCommand(infoCommand);
        canvas.removeCommand(helpCommand);
        canvas.removeCommand(backCommand);
        canvas.removeCommand(scoreCommand);
        canvas.removeCommand(newgameCommand);
        canvas.removeCommand(vibOffCommand);
        canvas.removeCommand(vibOnCommand);
        canvas.removeCommand(soundOffCommand);
        canvas.removeCommand(soundOnCommand);
        exitCommand = new Command(WormText.getText(WormText.LANGUAGE, 5), 7, 0);
        infoCommand = new Command(WormText.getText(WormText.LANGUAGE, 4), 1, 4);
        helpCommand = new Command(WormText.getText(WormText.LANGUAGE, 6), 1, 3);
        backCommand = new Command(WormText.getText(WormText.LANGUAGE, 1), 2, 2);
        scoreCommand = new Command(WormText.getText(WormText.LANGUAGE, 22), 1, 1);
        languageCommand = new Command(WormText.getText(WormText.LANGUAGE, 10), 1, 5);
        vibOffCommand = new Command(WormText.getText(WormText.LANGUAGE, 13), 2, 6);
        vibOnCommand = new Command(WormText.getText(WormText.LANGUAGE, 14), 2, 6);
        soundOffCommand = new Command(WormText.getText(WormText.LANGUAGE, 15), 2, 7);
        soundOnCommand = new Command(WormText.getText(WormText.LANGUAGE, 16), 2, 7);
        newgameCommand = new Command(WormText.getText(WormText.LANGUAGE, 12), 1, 8);
        canvas.addCommand(exitCommand);
        canvas.addCommand(infoCommand);
        canvas.addCommand(helpCommand);
        canvas.addCommand(backCommand);
        canvas.addCommand(scoreCommand);
        canvas.addCommand(languageCommand);
        canvas.addCommand(newgameCommand);
        if (vibrator) {
            canvas.addCommand(vibOffCommand);
        } else {
            canvas.addCommand(vibOnCommand);
        }
        if (sound) {
            canvas.addCommand(soundOffCommand);
        } else {
            canvas.addCommand(soundOnCommand);
        }
    }

    public void run() {
        if (!insidegame) {
            Light.setLightOn();
            welcomeCanvas = new WelcomeCanvas();
            welcomeCanvas.buildImage();
            display.setCurrent((Displayable)welcomeCanvas);
            Snake$InitGame snake$InitGame = new Snake$InitGame(this);
            snake$InitGame.getRecords();
        }
        Snake.setMenuLanguage();
        canvas.setCommandListener(this);
        canvas.run(this);
    }

    public void gameIsOver() {
        this.gameoverinfo = new Snake$GameOver(this);
        canvas.serviceRepaints();
        this.gameoverinfo.shows(display, this);
        Snake$GameOver.access$000(this.gameoverinfo, scoreval, score);
        canvas.displayScores();
    }

    protected void destroyApp(boolean bl) {
        Display.getDisplay((MIDlet)this).setCurrent(null);
        this.notifyDestroyed();
    }

    protected void pauseApp() {
        state = 3;
    }

    protected void startApp() {
        display = Display.getDisplay((MIDlet)this);
        Thread thread = new Thread(this);
        thread.setPriority(10);
        canvas = new SnakeCanvas();
        display.setCurrent((Displayable)canvas);
        thread.start();
    }

    public void shows() {
        display.setCurrent((Displayable)canvas);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == exitCommand) {
            if (datatosave) {
                canvas.displayGoodByeScreen();
                Snake.saveRecords();
            }
            this.destroyApp(false);
        }
        if (command == infoCommand) {
            this.showinformation = new ShowInfo();
            this.showinformation.shows(display, this);
        }
        if (command == helpCommand) {
            this.showhelpinfo = new ShowHelp();
            this.showhelpinfo.shows(display, this);
        }
        if (command == scoreCommand) {
            this.highscoreinfo = new Snake$ShowHighScore(this);
            this.highscoreinfo.shows(display, this);
        }
        if (command == languageCommand) {
            this.languageselect = new LanguageSelect();
            this.languageselect.shows(display, this);
        }
        if (command == vibOffCommand) {
            vibrator = false;
            datatosave = true;
            canvas.removeCommand(vibOffCommand);
            canvas.addCommand(vibOnCommand);
        }
        if (command == vibOnCommand) {
            vibrator = true;
            datatosave = true;
            canvas.removeCommand(vibOnCommand);
            canvas.addCommand(vibOffCommand);
        }
        if (command == soundOffCommand) {
            sound = false;
            datatosave = true;
            canvas.removeCommand(soundOffCommand);
            canvas.addCommand(soundOnCommand);
        }
        if (command == soundOnCommand) {
            sound = true;
            datatosave = true;
            canvas.removeCommand(soundOnCommand);
            canvas.addCommand(soundOffCommand);
        }
        if (command == newgameCommand) {
            this.startApp();
        }
    }

    static void playSound(int n) {
        switch (n) {
            case 1: {
                Snake.play(stopSound);
                break;
            }
            case 2: {
                Snake.play(diedSound);
                break;
            }
            case 3: {
                Snake.play(highscoreSound);
                break;
            }
            case 4: {
                Snake.play(eatenSound);
            }
        }
    }

    static void play(int[][] nArray) {
        int n = 0;
        while (nArray[n][1] != 0) {
            if (nArray[n][0] != 0) {
                Sound.playTone((int)nArray[n][0], (int)nArray[n][1]);
            }
            try {
                Thread.sleep(nArray[n][1]);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ++n;
        }
    }

    static void saveRecords() {
        int n = WormText.SAVEDLANGUAGE;
        boolean bl = vibrator;
        boolean bl2 = sound;
        datatosave = false;
        int n2 = newHighScore ? score : scoreval;
        try {
            try {
                String string = nameval;
                recordscore = RecordStore.openRecordStore((String)RSname, (boolean)false);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
                DataOutputStream dataOutputStream2 = new DataOutputStream(byteArrayOutputStream2);
                ByteArrayOutputStream byteArrayOutputStream3 = new ByteArrayOutputStream();
                DataOutputStream dataOutputStream3 = new DataOutputStream(byteArrayOutputStream3);
                ByteArrayOutputStream byteArrayOutputStream4 = new ByteArrayOutputStream();
                DataOutputStream dataOutputStream4 = new DataOutputStream(byteArrayOutputStream4);
                ByteArrayOutputStream byteArrayOutputStream5 = new ByteArrayOutputStream();
                DataOutputStream dataOutputStream5 = new DataOutputStream(byteArrayOutputStream5);
                try {
                    dataOutputStream.writeBoolean(true);
                    dataOutputStream.writeUTF(string);
                    namedata = byteArrayOutputStream.toByteArray();
                    dataOutputStream2.writeBoolean(true);
                    dataOutputStream2.writeInt(n2);
                    scoredata = byteArrayOutputStream2.toByteArray();
                    dataOutputStream3.writeBoolean(true);
                    dataOutputStream3.writeInt(n);
                    languagedata = byteArrayOutputStream3.toByteArray();
                    dataOutputStream4.writeBoolean(true);
                    dataOutputStream4.writeBoolean(bl);
                    vibdata = byteArrayOutputStream4.toByteArray();
                    dataOutputStream5.writeBoolean(true);
                    dataOutputStream5.writeBoolean(bl2);
                    sounddata = byteArrayOutputStream5.toByteArray();
                    if (recordscore.getNumRecords() == 0) {
                        scoreid = recordscore.addRecord(scoredata, 0, scoredata.length);
                        nameid = recordscore.addRecord(namedata, 0, namedata.length);
                        languageid = recordscore.addRecord(languagedata, 0, languagedata.length);
                        vibid = recordscore.addRecord(vibdata, 0, vibdata.length);
                        soundid = recordscore.addRecord(sounddata, 0, sounddata.length);
                    } else {
                        recordscore.closeRecordStore();
                        RecordStore.deleteRecordStore((String)RSname);
                        recordscore = RecordStore.openRecordStore((String)RSname, (boolean)true);
                        scoreid = recordscore.addRecord(scoredata, 0, scoredata.length);
                        nameid = recordscore.addRecord(namedata, 0, namedata.length);
                        languageid = recordscore.addRecord(languagedata, 0, languagedata.length);
                        vibid = recordscore.addRecord(vibdata, 0, vibdata.length);
                        soundid = recordscore.addRecord(sounddata, 0, sounddata.length);
                    }
                    scoredata = recordscore.getRecord(scoreid);
                    DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(scoredata));
                    boolean bl3 = dataInputStream.readBoolean();
                    scoreval = dataInputStream.readInt();
                    namedata = recordscore.getRecord(nameid);
                    DataInputStream dataInputStream2 = new DataInputStream(new ByteArrayInputStream(namedata));
                    boolean bl4 = dataInputStream2.readBoolean();
                    nameval = dataInputStream2.readUTF();
                    recordscore.closeRecordStore();
                }
                catch (IOException iOException) {
                }
            }
            catch (RecordStoreNotFoundException recordStoreNotFoundException) {}
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    static {
        instance = null;
        rand = new Random();
        state = 0;
        newHighScore = false;
        insidegame = false;
        datatosave = false;
        gameSound = new Sound();
        stopSound = new int[][]{{1047, 375}, {1175, 375}, {1047, 375}, {523, 375}, {784, 748}, {0, 0}};
        diedSound = new int[][]{{440, 10}, {467, 10}, {440, 10}, {467, 10}, {440, 10}, {467, 10}, {440, 10}, {467, 10}, {440, 10}, {467, 10}, {440, 10}, {467, 10}, {440, 10}, {467, 10}, {440, 10}, {467, 10}, {440, 10}, {467, 10}, {440, 10}, {467, 10}, {440, 10}, {467, 10}, {440, 10}, {467, 10}, {440, 10}, {467, 10}, {440, 10}, {467, 10}, {440, 10}, {467, 10}, {0, 0}};
        highscoreSound = new int[][]{{523, 150}, {659, 150}, {784, 150}, {1047, 72}, {0, 220}, {784, 150}, {1047, 600}, {0, 0}};
        eatenSound = new int[][]{{480, 3}, {470, 3}, {460, 3}, {450, 3}, {440, 3}, {450, 3}, {460, 3}, {470, 3}, {480, 3}, {0, 0}};
        RSname = "Initvalues";
        recordscore = null;
        nameid = 2;
        scoreid = 1;
        languageid = 3;
        vibid = 4;
        soundid = 5;
    }
}

