/*
 * Decompiled with CFR 0.152.
 */
package worm;

import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import worm.Point;
import worm.Snake;
import worm.Worm;

class Playground {
    static final int ELEMENT_DIAMETER = 3;
    static int WIDTH = Snake.GAME_WIDTH / 3;
    static int HEIGHT = Snake.GAME_HEIGHT / 3;
    static final int NONE = 0;
    static final int FOOD = 1;
    static final int BRICK = 2;
    static final int WORM = 3;
    private static final Image[] bitmaps;
    static int[][] field;
    static int[][] nextField;
    static Point[] changesPoints;
    static int numberOfChanges;
    static Image playGround;
    static Graphics buffer;
    static Graphics g;

    Playground(int n, Graphics graphics) {
        Point point;
        g = graphics;
        graphics.setFont(Font.getFont((int)64, (int)0, (int)8));
        field = new int[WIDTH][HEIGHT];
        nextField = new int[WIDTH][HEIGHT];
        int n2 = 0;
        while (n2 < WIDTH) {
            int n3 = 0;
            while (n3 < HEIGHT) {
                Playground.field[n2][n3] = 0;
                Playground.nextField[n2][n3] = 0;
                ++n3;
            }
            ++n2;
        }
        changesPoints = new Point[WIDTH * HEIGHT];
        numberOfChanges = 0;
        int n4 = 0;
        while (n4 < WIDTH) {
            Playground.setBrick(new Point(n4, 0));
            Playground.setBrick(new Point(n4, HEIGHT - 1));
            ++n4;
        }
        int n5 = 1;
        while (n5 < HEIGHT - 1) {
            Playground.setBrick(new Point(0, n5));
            Playground.setBrick(new Point(WIDTH - 1, n5));
            ++n5;
        }
        switch (n) {
            case 1: {
                point = new Point(WIDTH / 2, HEIGHT / 2);
                break;
            }
            case 2: {
                int n6 = WIDTH / 3;
                while (n6 <= WIDTH * 2 / 3) {
                    Playground.setBrick(new Point(n6, HEIGHT / 2));
                    ++n6;
                }
                point = new Point(WIDTH / 2, HEIGHT / 4);
                break;
            }
            case 3: {
                int n7 = 2;
                while (n7 < HEIGHT - 1) {
                    Playground.setBrick(new Point(WIDTH / 2, n7));
                    n7 += 2;
                }
                point = new Point(WIDTH / 4, HEIGHT / 2);
                break;
            }
            case 4: {
                int n8 = 1;
                while (n8 < HEIGHT * 2 / 3) {
                    Playground.setBrick(new Point(WIDTH / 5, n8));
                    Playground.setBrick(new Point(WIDTH * 3 / 5, n8));
                    ++n8;
                }
                int n9 = HEIGHT - 1;
                while (n9 > HEIGHT / 3) {
                    Playground.setBrick(new Point(WIDTH * 2 / 5, n9));
                    Playground.setBrick(new Point(WIDTH * 4 / 5, n9));
                    --n9;
                }
                point = new Point(WIDTH / 2, HEIGHT / 2);
                break;
            }
            case 5: {
                int n10 = WIDTH / 3;
                while (n10 <= 2 * WIDTH / 3) {
                    if (n10 != WIDTH / 2) {
                        Playground.setBrick(new Point(n10, HEIGHT / 3));
                        Playground.setBrick(new Point(n10, HEIGHT * 2 / 3));
                    }
                    ++n10;
                }
                int n11 = HEIGHT / 3;
                while (n11 <= HEIGHT * 2 / 3) {
                    if (n11 != HEIGHT / 2) {
                        Playground.setBrick(new Point(WIDTH / 3, n11));
                        Playground.setBrick(new Point(WIDTH * 2 / 3, n11));
                    }
                    ++n11;
                }
                point = new Point(WIDTH / 2, HEIGHT / 6);
                break;
            }
            case 6: {
                int n12 = 1;
                while (n12 < WIDTH) {
                    if (n12 != WIDTH / 3 && n12 != WIDTH * 2 / 3) {
                        Playground.setBrick(new Point(n12, HEIGHT / 4));
                        Playground.setBrick(new Point(n12, HEIGHT * 3 / 4));
                    }
                    if (n12 != WIDTH / 2) {
                        Playground.setBrick(new Point(n12, HEIGHT / 2));
                    }
                    ++n12;
                }
                point = new Point(WIDTH / 2, 2);
                break;
            }
            default: {
                point = new Point(WIDTH / 2, HEIGHT / 2);
                int n13 = 0;
                while (n13 < n * 3 + 20 * WIDTH * HEIGHT / 800) {
                    Point point2;
                    do {
                        point2 = new Point(Math.abs(Snake.randomInt()) % (WIDTH - 2) + 1, Math.abs(Snake.randomInt()) % (HEIGHT - 2) + 1);
                    } while (point2.y == point.y && point2.x >= point.x && point2.x <= point.x + 3);
                    Playground.setBrick(point2);
                    ++n13;
                }
                break block0;
            }
        }
        Snake.INITIAL_LENGTH = Math.max(WIDTH * HEIGHT / 100, 1);
        Snake.GROWTH_RATE = Math.max(Snake.INITIAL_LENGTH / 2, 1);
        Snake.worm = new Worm(3, point, Snake.INITIAL_LENGTH);
        this.clearBuffer();
        Playground.update();
    }

    public void clearBuffer() {
        int n = g.getColor();
        buffer.setColor(255, 255, 255);
        buffer.fillRect(0, 0, Snake.GAME_WIDTH - 1, Snake.GAME_HEIGHT - 1);
        buffer.setColor(n);
    }

    private static void setBrick(Point point) {
        Playground.nextField[point.x][point.y] = 2;
        Playground.changesPoints[Playground.numberOfChanges++] = point;
    }

    static void setFood(Point point) {
        Playground.nextField[point.x][point.y] = 1;
        Playground.changesPoints[Playground.numberOfChanges++] = point;
    }

    static void setWorm(Point point, int n) {
        Playground.nextField[point.x][point.y] = n;
        Playground.changesPoints[Playground.numberOfChanges++] = point;
    }

    static void clearElement(Point point) {
        Playground.nextField[point.x][point.y] = 0;
        Playground.changesPoints[Playground.numberOfChanges++] = point;
    }

    static int getElement(Point point) {
        return field[point.x][point.y];
    }

    private static void drawElement(int n, int n2) {
        buffer.drawImage(bitmaps[field[n][n2]], n * 3, n2 * 3, 20);
    }

    static void update() {
        int n = 0;
        while (n < numberOfChanges) {
            int n2 = Playground.changesPoints[n].x;
            int n3 = Playground.changesPoints[n].y;
            Playground.field[n2][n3] = nextField[n2][n3];
            Playground.drawElement(n2, n3);
            ++n;
        }
        numberOfChanges = 0;
        g.drawImage(playGround, 0, 0, 20);
    }

    static void drawAllElements() {
        g.drawImage(playGround, 0, 0, 20);
    }

    static {
        playGround = Image.createImage((int)Snake.GAME_WIDTH, (int)Snake.GAME_HEIGHT);
        buffer = playGround.getGraphics();
        bitmaps = new Image[4];
        byte[][] byArrayArray = new byte[][]{{0, 0, 0}, {-96, 64, -96}, {-32, -32, -32}, {-32, -96, -32}};
        int n = 0;
        while (n <= 3) {
            Playground.bitmaps[n] = com.siemens.mp.ui.Image.createImageFromBitmap((byte[])byArrayArray[n], (int)3, (int)3);
            ++n;
        }
    }
}

