/*
 * Decompiled with CFR 0.152.
 */
package simpledemos.uidemo;

import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;
import javax.microedition.midlet.MIDlet;
import simpledemos.uidemo.UIDemo;

public class UIDemo
extends MIDlet
implements CommandListener {
    private static UIDemo instance = null;
    private Displayable currentDemo = null;
    private Class[] demos = new Class[]{UIDemo.getClassObject("simpledemos.uidemo.LabelDemo"), UIDemo.getClassObject("simpledemos.uidemo.DateFieldDemo"), UIDemo.getClassObject("simpledemos.uidemo.AlertDemo"), UIDemo.getClassObject("simpledemos.uidemo.ChoiceGroupDemo"), UIDemo.getClassObject("simpledemos.uidemo.GaugeDemo"), UIDemo.getClassObject("simpledemos.uidemo.ImageItemDemo"), UIDemo.getClassObject("simpledemos.uidemo.ListDemo"), UIDemo.getClassObject("simpledemos.uidemo.TextBoxDemo"), UIDemo.getClassObject("simpledemos.uidemo.TextFieldDemo"), UIDemo.getClassObject("simpledemos.uidemo.TickerDemo")};
    private static final String[] demoNames = new String[]{"Label", "Date Field", "Alerts", "Choice Group", "Gauge", "Image Item", "List", "Text Box", "Text Field", "Ticker", "Exit"};
    private List selectionList = new List("UI Demo", 3, demoNames, null);
    private static boolean eternalLoop = false;

    private static Class getClassObject(String string) {
        try {
            return Class.forName(string);
        }
        catch (Throwable throwable) {
            System.out.println(throwable.getClass().getName() + ": " + throwable.getMessage());
            throwable.printStackTrace();
            return null;
        }
    }

    static UIDemo getInstance() {
        return instance;
    }

    public static void main(String[] stringArray) {
        UIDemo uIDemo = new UIDemo();
        uIDemo.startApp();
    }

    public UIDemo() {
        instance = this;
    }

    protected void destroyApp(boolean bl) {
        this.demos = null;
        this.selectionList = null;
        this.currentDemo = null;
        Display.getDisplay((MIDlet)this).setCurrent(null);
        this.notifyDestroyed();
    }

    protected void pauseApp() {
    }

    protected void startApp() {
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.selectionList);
        this.selectionList.setCommandListener((CommandListener)this);
        if (!eternalLoop) {
            eternalLoop = true;
            while (true) {
                // Infinite loop
            }
        }
    }

    public static void quit() {
        instance.destroyApp(true);
        instance = null;
    }

    public static void goBack() {
        UIDemo.instance.currentDemo = null;
        instance.startApp();
    }

    Displayable getCurrentDemo() {
        return this.currentDemo;
    }

    public void commandAction(Command command, Displayable displayable) {
        int n = this.selectionList.getSelectedIndex();
        if (n == demoNames.length - 1) {
            this.destroyApp(false);
        } else {
            try {
                this.currentDemo = (Displayable)this.demos[n].newInstance();
                Display.getDisplay((MIDlet)this).setCurrent(this.currentDemo);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static Command[] getDemoCommands() {
        Command[] commandArray = new Command[]{new Command("Back", 2, 1), new Command("Quit", 6, 2)};
        return commandArray;
    }

    static Runnable[] getDemoActions() {
        class BackCallback
        implements Runnable {
            BackCallback() {
            }

            public void run() {
                UIDemo.goBack();
            }
        }
        class QuitCallback
        implements Runnable {
            QuitCallback() {
            }

            public void run() {
                UIDemo.quit();
            }
        }
        Runnable[] runnableArray = new Runnable[]{new BackCallback(), new QuitCallback()};
        return runnableArray;
    }
}

