/*
 * Decompiled with CFR 0.152.
 */
package nim;

import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import nim.Backable;
import nim.Game;
import nim.GameOptions;
import nim.NimCalculator;
import nim.WinLoose;

public class GameControl
extends Canvas
implements Backable {
    private static final Command[] COMMANDS = new Command[]{new Command("Select", 1, 1), new Command("Hint", 1, 2), new Command("Exit", 1, 3), new Command("Cancel", 3, 4)};
    public static final byte GAMESTATE_PLAYING = 0;
    public static final byte GAMESTATE_HINT = 1;
    private byte gameState;
    private static final int offsetX = 4;
    private static final int offsetY = 2;
    WinLoose winloose;
    Display display;
    Backable go_back;
    Game game;
    NimCalculator calc;
    private int[] calcResponse;
    private Font font;
    private int canvasWidth;
    private int canvasHeight;
    private int markedHeap;
    private int markedPieces;
    private int cellHeight;
    private int cellWidth;
    private int playAreaOffsetY;

    public GameControl() {
        this.createGame();
    }

    public void showMe(Display display, Backable backable) {
        this.go_back = backable;
        this.display = display;
        this.showMe();
    }

    public void showMe() {
        this.display.setCurrent((Displayable)this);
        this.setCommandListener(this);
    }

    public void createGame() {
        this.canvasWidth = this.getWidth();
        this.canvasHeight = this.getHeight();
        this.setState((byte)0);
        this.game = new Game(GameOptions.getHeapsGO(), GameOptions.getPiecesFirstHeapGO(), true);
        this.calc = new NimCalculator(GameOptions.getRationalGO());
        this.markedHeap = this.findNextHeap(0, false);
        this.markedPieces = 1;
        this.font = Font.getFont((int)0, (int)1, (int)0);
        this.playAreaOffsetY = this.font.getHeight() + 2;
        this.cellWidth = (this.canvasWidth - 8) / (GameOptions.getPiecesFirstHeapGO() + GameOptions.getHeapsGO() - 1);
        this.cellHeight = (this.canvasHeight - this.playAreaOffsetY - 4) / GameOptions.getHeapsGO();
    }

    public void paint(Graphics graphics) {
        graphics.setColor(0xFFFFFF);
        graphics.fillRect(0, 0, this.canvasWidth, this.canvasHeight);
        graphics.setColor(0);
        graphics.setFont(this.font);
        String string = this.gameState == 1 ? (this.calcResponse[0] >= 0 ? "* Hint for you *" : "Sorry, no hints") : (this.game.isPlayersTurn() ? "*** Your turn ***" : "*** NIM turn ***");
        graphics.drawString(string, this.canvasWidth / 2, 2, 17);
        byte[] byArray = this.game.getGame();
        int n = 0;
        while (n < byArray.length) {
            int n2;
            int n3;
            if (this.game.isPlayersTurn() && this.gameState == 0) {
                n3 = this.markedHeap;
                n2 = this.markedPieces;
            } else {
                n3 = this.calcResponse[0];
                int n4 = n2 = this.game.isPlayersTurn() ? this.calcResponse[1] : this.markedPieces;
            }
            if (n == n3 && byArray[n] > 0) {
                graphics.drawRect(4 + (byArray[n] - n2) * this.cellWidth, this.playAreaOffsetY + 2 + this.cellHeight * n, this.cellWidth * n2 - 1, this.cellHeight - 1);
            }
            int n5 = 0;
            while (n5 < byArray[n]) {
                graphics.fillArc(4 + this.cellWidth * n5 + 1, this.playAreaOffsetY + 2 + this.cellHeight * n + 1, this.cellWidth - 2, this.cellHeight - 2, 0, 360);
                ++n5;
            }
            ++n;
        }
    }

    public void keyPressed(int n) {
        if (this.gameState == 0) {
            int n2 = this.getGameAction(n);
            switch (n2) {
                case 1: {
                    --this.markedHeap;
                    if (this.markedHeap < 0) {
                        this.markedHeap = this.game.getNumberOfHeaps() - 1;
                    }
                    this.markedHeap = this.findNextHeap(this.markedHeap, true);
                    this.markedPieces = 1;
                    this.repaint();
                    break;
                }
                case 6: {
                    ++this.markedHeap;
                    if (this.markedHeap > this.game.getNumberOfHeaps() - 1) {
                        this.markedHeap = 0;
                    }
                    this.markedHeap = this.findNextHeap(this.markedHeap, false);
                    this.markedPieces = 1;
                    this.repaint();
                    break;
                }
                case 2: {
                    if (this.markedPieces < this.game.getHeap(this.markedHeap)) {
                        ++this.markedPieces;
                    }
                    this.repaint();
                    break;
                }
                case 5: {
                    if (this.markedPieces > 1) {
                        --this.markedPieces;
                    }
                    this.repaint();
                    break;
                }
                case 8: {
                    this.game.removePieces(this.markedHeap, this.markedPieces);
                    if (this.game.isEmpty()) {
                        this.gameIsOver();
                        this.winloose.setWinnerScreen();
                        this.winloose.showMe(this.display, this);
                        this.createGame();
                        break;
                    }
                    this.calcResponse = this.calc.calculate(false);
                    this.markedPieces = 1;
                    while (this.markedPieces <= this.calcResponse[1]) {
                        this.repaint();
                        this.serviceRepaints();
                        this.millisecondsWait(400L);
                        ++this.markedPieces;
                    }
                    this.millisecondsWait(400L);
                    this.game.removePieces(this.calcResponse[0], this.calcResponse[1]);
                    if (this.game.isEmpty()) {
                        this.gameIsOver();
                        this.winloose.setLooserScreen();
                        this.winloose.showMe(this.display, this);
                        this.createGame();
                        break;
                    }
                    this.markedPieces = 1;
                    this.markedHeap = this.findNextHeap(this.markedHeap, false);
                    this.repaint();
                }
            }
        }
    }

    void setState(byte by) {
        this.gameState = by;
        int n = 0;
        while (n < COMMANDS.length) {
            if (this.gameState == 1) {
                this.removeCommand(COMMANDS[n]);
            } else {
                this.addCommand(COMMANDS[n]);
            }
            ++n;
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == COMMANDS[0]) {
            this.keyPressed(this.getKeyCode(8));
        } else if (command == COMMANDS[1]) {
            this.setState((byte)1);
            this.calcResponse = this.calc.calculate(true);
            this.repaint();
            this.serviceRepaints();
            this.millisecondsWait(1500L);
            this.setState((byte)0);
        } else if (command == COMMANDS[2]) {
            this.gameIsOver();
            this.winloose.setSurrenderScreen();
            this.winloose.showMe(this.display, this);
            this.createGame();
        }
        this.repaint();
    }

    private int findNextHeap(int n, boolean bl) {
        int n2 = n;
        boolean bl2 = this.game.isHeapEmpty(n2);
        int n3 = 0;
        while (n3 < this.game.getNumberOfHeaps() && bl2) {
            if (!bl) {
                if (++n2 >= this.game.getNumberOfHeaps()) {
                    n2 = 0;
                }
            } else if (--n2 < 0) {
                n2 = this.game.getNumberOfHeaps() - 1;
            }
            if (!this.game.isHeapEmpty(n2)) {
                bl2 = false;
            }
            ++n3;
        }
        return n2;
    }

    private void gameIsOver() {
        this.winloose = new WinLoose(this.display, this, this.go_back);
    }

    private synchronized void millisecondsWait(long l) {
        if (l <= 0L) {
            l = 1L;
        }
        try {
            this.wait(l);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

