/*
 * Decompiled with CFR 0.152.
 */
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import java.util.Vector;

public class CoctailBar {
    Hashtable coctails;
    Random random;

    public CoctailBar() {
        this(10);
    }

    public CoctailBar(int barSize) {
        this.coctails = new Hashtable(barSize);
        this.random = new Random();
    }

    public void addCoctail(Coctail coctail) {
        this.coctails.put(coctail.getName(), coctail);
    }

    public void addCoctail(String name, String ingredients, String recipe) {
        Coctail c = new Coctail(name, ingredients, recipe);
        this.coctails.put(name, c);
    }

    public Coctail getCoctail(String name) {
        name = name.toUpperCase();
        Enumeration enumeration = this.coctails.keys();
        String coctail = null;
        while (enumeration.hasMoreElements()) {
            coctail = (String)enumeration.nextElement();
            if (name.equals(coctail.toUpperCase())) break;
        }
        return (Coctail)this.coctails.get(coctail);
    }

    public Coctail getRandomCoctail() {
        Coctail coctail;
        Enumeration enumeration = this.coctails.elements();
        int i = Math.abs(this.random.nextInt() % this.coctails.size());
        int j = 0;
        do {
            coctail = (Coctail)enumeration.nextElement();
        } while (j++ < i && enumeration.hasMoreElements());
        return coctail;
    }

    public Coctail setScore(String coctailName, int score) {
        Coctail coctail = this.getCoctail(coctailName);
        coctail.setScore(score);
        return coctail;
    }

    public String[] searchCoctail(String byName, String byIngredients) {
        Vector coctails = null;
        if (byName.length() != 0) {
            coctails = this.searchCoctailByName(byName.toUpperCase());
        } else if (byIngredients.length() != 0) {
            coctails = this.searchCoctailByIngredients(byIngredients.toUpperCase());
        }
        Object[] coctailList = new String[coctails.size()];
        coctails.copyInto(coctailList);
        return coctailList;
    }

    private Vector searchCoctailByName(String name) {
        Enumeration enumeration = this.coctails.keys();
        String key = null;
        Vector<String> coctailList = new Vector<String>();
        while (enumeration.hasMoreElements()) {
            key = (String)enumeration.nextElement();
            if ((key = key.toUpperCase()).indexOf(name) == -1) continue;
            coctailList.addElement(key);
        }
        return coctailList;
    }

    private Vector searchCoctailByIngredients(String ingredients) {
        Enumeration enumeration = this.coctails.elements();
        Object key = null;
        Vector<String> coctailList = new Vector<String>();
        while (enumeration.hasMoreElements()) {
            Coctail coctail = (Coctail)enumeration.nextElement();
            String coctailIngredients = coctail.getIngredients().toUpperCase();
            if (coctailIngredients.indexOf(ingredients) == -1) continue;
            coctailList.addElement(coctail.getName());
        }
        return coctailList;
    }

    public String[] getCoctailList() {
        Enumeration enumeration = this.coctails.keys();
        String[] coctailList = new String[this.coctails.size()];
        int i = 0;
        while (enumeration.hasMoreElements()) {
            coctailList[i++] = (String)enumeration.nextElement();
        }
        return coctailList;
    }
}

