/*
 * Decompiled with CFR 0.152.
 */
import com.siemens.mp.gsm.SMS;
import java.io.IOException;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.ImageItem;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.TextField;
import javax.microedition.midlet.MIDlet;

public class App
extends MIDlet
implements CommandListener {
    private Display display = Display.getDisplay((MIDlet)this);
    private List menuScreen;
    private List browseScreen;
    private Form searchScreen;
    private Form coctailScreen;
    private Form newCoctailScreen;
    private Form SMSScreen;
    private Form splashScreen;
    private Form helpScreen;
    private Command menuCommand;
    private Command quitCommand;
    private Command exitCommand;
    private Command backCommand;
    private Command aboutCommand;
    private Command helpCommand;
    private Command searchCommand;
    private Command newCommand;
    private Command score1Command;
    private Command score2Command;
    private Command score3Command;
    private Command score4Command;
    private Command score5Command;
    private Command sendSMSCommand;
    private CoctailBar coctailBar;
    private TextField phoneNumberField;
    private TextField searchByNameField;
    private TextField searchByIngredientsField;
    private TextField coctailNameField;
    private TextField coctailIngredientsField;
    private TextField coctailRecipeField;

    private void showSplash() {
        Image splashImage = null;
        try {
            splashImage = Image.createImage((String)"/splash.png");
        }
        catch (IOException ignored) {
            // empty catch block
        }
        this.splashScreen = new Form(CoctailDatabase.getString(0));
        ImageItem it = new ImageItem("SL45i/6688i", splashImage, 3, null);
        this.splashScreen.append((Item)it);
        this.menuCommand = new Command(CoctailDatabase.getString(2), 1, 1);
        this.quitCommand = new Command(CoctailDatabase.getString(1), 2, 2);
        this.aboutCommand = new Command(CoctailDatabase.getString(21), 1, 3);
        this.helpCommand = new Command(CoctailDatabase.getString(22), 1, 4);
        this.splashScreen.addCommand(this.quitCommand);
        this.splashScreen.addCommand(this.menuCommand);
        this.splashScreen.addCommand(this.aboutCommand);
        this.splashScreen.addCommand(this.helpCommand);
        this.splashScreen.setCommandListener((CommandListener)this);
        this.display.setCurrent((Displayable)this.splashScreen);
    }

    private void showAbout() {
        Alert about = new Alert(CoctailDatabase.getString(21));
        about.setString("version 1.11\n\n(c)2001 Cocoasoft\nwww.cocoasoft.com");
        this.display.setCurrent(about, (Displayable)this.splashScreen);
    }

    private void showHelp() {
        this.helpScreen = new Form(CoctailDatabase.getString(22));
        this.helpScreen.append(CoctailDatabase.getString(23));
        this.backCommand = new Command(CoctailDatabase.getString(4), 2, 1);
        this.helpScreen.addCommand(this.backCommand);
        this.helpScreen.setCommandListener((CommandListener)this);
        this.display.setCurrent((Displayable)this.helpScreen);
    }

    private void buildListUI() {
        String[] list = new String[]{CoctailDatabase.getString(12), CoctailDatabase.getString(14), CoctailDatabase.getString(15), CoctailDatabase.getString(16)};
        this.menuScreen = new List(CoctailDatabase.getString(0), 3, list, null);
        this.exitCommand = new Command(CoctailDatabase.getString(1), 7, 1);
        this.menuScreen.addCommand(this.exitCommand);
        this.menuScreen.setCommandListener((CommandListener)this);
    }

    private void showCoctail(Coctail coctail) {
        this.coctailScreen = new Form(coctail.getName());
        this.coctailScreen.append(coctail.createCoctailDisplay());
        int score = coctail.getScore();
        if (score > 0) {
            this.coctailScreen.append(CoctailDatabase.getString(17) + ": " + score);
        }
        this.backCommand = new Command(CoctailDatabase.getString(4), 2, 1);
        this.coctailScreen.addCommand(this.backCommand);
        this.sendSMSCommand = new Command(CoctailDatabase.getString(19), 1, 2);
        this.coctailScreen.addCommand(this.sendSMSCommand);
        if (score == 0) {
            this.score1Command = new Command(CoctailDatabase.getString(3) + " - 1", 1, 3);
            this.score2Command = new Command(CoctailDatabase.getString(3) + " - 2", 1, 4);
            this.score3Command = new Command(CoctailDatabase.getString(3) + " - 3", 1, 5);
            this.score4Command = new Command(CoctailDatabase.getString(3) + " - 4", 1, 6);
            this.score5Command = new Command(CoctailDatabase.getString(3) + " - 5", 1, 7);
            this.coctailScreen.addCommand(this.score1Command);
            this.coctailScreen.addCommand(this.score2Command);
            this.coctailScreen.addCommand(this.score3Command);
            this.coctailScreen.addCommand(this.score4Command);
            this.coctailScreen.addCommand(this.score5Command);
        }
        this.coctailScreen.setCommandListener((CommandListener)this);
        this.display.setCurrent((Displayable)this.coctailScreen);
    }

    private void browseCoctails(String[] coctailList) {
        this.browseScreen = new List(CoctailDatabase.getString(12), 3, coctailList, null);
        this.menuCommand = new Command(CoctailDatabase.getString(2), 2, 1);
        this.browseScreen.addCommand(this.menuCommand);
        this.browseScreen.setCommandListener((CommandListener)this);
        this.display.setCurrent((Displayable)this.browseScreen);
    }

    private void searchCoctail() {
        this.searchScreen = new Form(CoctailDatabase.getString(14));
        this.searchByNameField = new TextField(CoctailDatabase.getString(7), "", 30, 0);
        this.searchByIngredientsField = new TextField(CoctailDatabase.getString(8), "", 30, 0);
        this.searchScreen.append((Item)this.searchByNameField);
        this.searchScreen.append((Item)this.searchByIngredientsField);
        this.menuCommand = new Command(CoctailDatabase.getString(2), 2, 1);
        this.searchScreen.addCommand(this.menuCommand);
        this.searchCommand = new Command(CoctailDatabase.getString(5), 1, 2);
        this.searchScreen.addCommand(this.searchCommand);
        this.searchScreen.setCommandListener((CommandListener)this);
        this.display.setCurrent((Displayable)this.searchScreen);
    }

    private void showRandomCoctail() {
        Coctail coctail = this.coctailBar.getRandomCoctail();
        this.showCoctail(coctail);
    }

    private void createNewCoctail() {
        this.newCoctailScreen = new Form(CoctailDatabase.getString(18));
        this.coctailNameField = new TextField(CoctailDatabase.getString(9) + ":", "", 30, 0);
        this.coctailIngredientsField = new TextField(CoctailDatabase.getString(10) + ":", "", 60, 0);
        this.coctailRecipeField = new TextField(CoctailDatabase.getString(11) + ":", "", 200, 0);
        this.newCoctailScreen.append((Item)this.coctailNameField);
        this.newCoctailScreen.append((Item)this.coctailIngredientsField);
        this.newCoctailScreen.append((Item)this.coctailRecipeField);
        this.menuCommand = new Command(CoctailDatabase.getString(2), 2, 1);
        this.newCoctailScreen.addCommand(this.menuCommand);
        this.newCommand = new Command(CoctailDatabase.getString(6), 1, 2);
        this.newCoctailScreen.addCommand(this.newCommand);
        this.newCoctailScreen.setCommandListener((CommandListener)this);
        this.display.setCurrent((Displayable)this.newCoctailScreen);
    }

    private void selectSMSNumber(String name) {
        this.SMSScreen = new Form(name);
        this.phoneNumberField = new TextField(CoctailDatabase.getString(20), "", 20, 2);
        this.SMSScreen.append((Item)this.phoneNumberField);
        this.backCommand = new Command(CoctailDatabase.getString(4), 2, 1);
        this.SMSScreen.addCommand(this.backCommand);
        this.sendSMSCommand = new Command(CoctailDatabase.getString(19), 1, 2);
        this.SMSScreen.addCommand(this.sendSMSCommand);
        this.SMSScreen.setCommandListener((CommandListener)this);
        this.display.setCurrent((Displayable)this.SMSScreen);
    }

    private void SendCoctailSMS(String number, String name) {
        Coctail coctail = this.coctailBar.getCoctail(name);
        String coctailSMS = coctail.createCoctailSMS();
        try {
            SMS sms = new SMS();
            if (coctailSMS.length() > 160) {
                int startIndex = 0;
                int stopIndex = 159;
                while (startIndex < coctailSMS.length()) {
                    SMS.send((String)number, (String)coctailSMS.substring(startIndex, stopIndex));
                    startIndex = stopIndex;
                    if ((stopIndex += 159) <= coctailSMS.length()) continue;
                    stopIndex = coctailSMS.length();
                }
            } else {
                SMS.send((String)number, (String)coctailSMS);
            }
        }
        catch (Exception ignored) {
            // empty catch block
        }
        this.showCoctail(coctail);
    }

    protected void startApp() {
        this.coctailBar = new CoctailBar();
        CoctailDatabase.loadCoctails(this.coctailBar);
        this.showSplash();
        this.buildListUI();
        this.display.setCurrent((Displayable)this.splashScreen);
    }

    protected void pauseApp() {
    }

    protected void destroyApp(boolean b) {
    }

    public void exit() {
        this.destroyApp(false);
        this.notifyDestroyed();
    }

    public void commandAction(Command c, Displayable d) {
        if (c == this.exitCommand || c == this.quitCommand) {
            this.exit();
        }
        if (d == this.splashScreen) {
            if (c == this.menuCommand) {
                this.display.setCurrent((Displayable)this.menuScreen);
            } else if (c == this.aboutCommand) {
                this.showAbout();
            } else if (c == this.helpCommand) {
                this.showHelp();
            }
        } else if (d == this.menuScreen) {
            if (c == List.SELECT_COMMAND) {
                int choice = this.menuScreen.getSelectedIndex();
                switch (choice) {
                    case 0: {
                        this.browseCoctails(this.coctailBar.getCoctailList());
                        break;
                    }
                    case 1: {
                        this.searchCoctail();
                        break;
                    }
                    case 2: {
                        this.showRandomCoctail();
                        break;
                    }
                    case 3: {
                        this.createNewCoctail();
                    }
                }
            }
        } else if (d == this.browseScreen) {
            if (c == this.menuCommand) {
                this.display.setCurrent((Displayable)this.menuScreen);
            } else {
                String choice = this.browseScreen.getString(this.browseScreen.getSelectedIndex());
                this.showCoctail(this.coctailBar.getCoctail(choice));
            }
        } else if (d == this.coctailScreen) {
            if (c == this.backCommand) {
                this.display.setCurrent((Displayable)this.menuScreen);
            } else if (c == this.sendSMSCommand) {
                this.selectSMSNumber(this.coctailScreen.getTitle());
            } else if (c == this.score1Command) {
                CoctailDatabase.storeScore(this.coctailBar.setScore(this.coctailScreen.getTitle(), 1));
                this.coctailScreen.removeCommand(this.score1Command);
                this.coctailScreen.removeCommand(this.score2Command);
                this.coctailScreen.removeCommand(this.score3Command);
                this.coctailScreen.removeCommand(this.score4Command);
                this.coctailScreen.removeCommand(this.score5Command);
                this.coctailScreen.append(CoctailDatabase.getString(17) + ": " + 1);
            } else if (c == this.score2Command) {
                CoctailDatabase.storeScore(this.coctailBar.setScore(this.coctailScreen.getTitle(), 2));
                this.coctailScreen.removeCommand(this.score1Command);
                this.coctailScreen.removeCommand(this.score2Command);
                this.coctailScreen.removeCommand(this.score3Command);
                this.coctailScreen.removeCommand(this.score4Command);
                this.coctailScreen.removeCommand(this.score5Command);
                this.coctailScreen.append(CoctailDatabase.getString(17) + ": " + 2);
            } else if (c == this.score3Command) {
                CoctailDatabase.storeScore(this.coctailBar.setScore(this.coctailScreen.getTitle(), 3));
                this.coctailScreen.removeCommand(this.score1Command);
                this.coctailScreen.removeCommand(this.score2Command);
                this.coctailScreen.removeCommand(this.score3Command);
                this.coctailScreen.removeCommand(this.score4Command);
                this.coctailScreen.removeCommand(this.score5Command);
                this.coctailScreen.append(CoctailDatabase.getString(17) + ": " + 3);
            } else if (c == this.score4Command) {
                CoctailDatabase.storeScore(this.coctailBar.setScore(this.coctailScreen.getTitle(), 4));
                this.coctailScreen.removeCommand(this.score1Command);
                this.coctailScreen.removeCommand(this.score2Command);
                this.coctailScreen.removeCommand(this.score3Command);
                this.coctailScreen.removeCommand(this.score4Command);
                this.coctailScreen.removeCommand(this.score5Command);
                this.coctailScreen.append(CoctailDatabase.getString(17) + ": " + 4);
            } else if (c == this.score5Command) {
                CoctailDatabase.storeScore(this.coctailBar.setScore(this.coctailScreen.getTitle(), 5));
                this.coctailScreen.removeCommand(this.score1Command);
                this.coctailScreen.removeCommand(this.score2Command);
                this.coctailScreen.removeCommand(this.score3Command);
                this.coctailScreen.removeCommand(this.score4Command);
                this.coctailScreen.removeCommand(this.score5Command);
                this.coctailScreen.append(CoctailDatabase.getString(17) + ": " + 5);
            }
        } else if (d == this.newCoctailScreen) {
            if (c == this.newCommand) {
                Coctail coctail = new Coctail(this.coctailNameField.getString(), this.coctailIngredientsField.getString(), this.coctailRecipeField.getString());
                this.coctailBar.addCoctail(coctail);
                CoctailDatabase.storeCoctail(coctail);
                this.display.setCurrent((Displayable)this.menuScreen);
            } else if (c == this.menuCommand) {
                this.display.setCurrent((Displayable)this.menuScreen);
            }
        } else if (d == this.searchScreen) {
            if (c == this.menuCommand) {
                this.display.setCurrent((Displayable)this.menuScreen);
            } else if (c == this.searchCommand) {
                String[] coctailList;
                String searchByIngredients;
                String searchByName = this.searchByNameField.getString();
                if (searchByName == null) {
                    searchByName = new String("");
                }
                if ((searchByIngredients = this.searchByIngredientsField.getString()) == null) {
                    searchByIngredients = new String("");
                }
                if ((coctailList = this.coctailBar.searchCoctail(searchByName, searchByIngredients)) != null) {
                    this.browseCoctails(coctailList);
                } else {
                    this.display.setCurrent((Displayable)this.searchScreen);
                }
            }
        } else if (d == this.SMSScreen) {
            if (c == this.backCommand) {
                this.showCoctail(this.coctailBar.getCoctail(this.SMSScreen.getTitle()));
            } else if (c == this.sendSMSCommand) {
                this.SendCoctailSMS(this.phoneNumberField.getString(), this.SMSScreen.getTitle());
            }
        } else if (d == this.helpScreen && c == this.backCommand) {
            this.showSplash();
        }
    }
}

