/*
 * Decompiled with CFR 0.152.
 */
public class WeatherInfo {
    static final boolean EMULATOR = false;
    public static final short[] key2code = new short[]{100, 101, 102, 103, 104, 105, 106, 107, 108, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 140, 160, 170, 181, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224, 225, 226, 227, 228, 229, 230, 231, 240, 250, 260, 270, 281, 300, 301, 302, 303, 304, 306, 308, 309, 311, 313, 314, 315, 316, 317, 320, 321, 322, 323, 324, 325, 326, 327, 328, 329, 340, 350, 361, 371, 400, 401, 402, 403, 405, 406, 407, 409, 411, 413, 414, 420, 421, 422, 423, 424, 425, 426, 427, 450, 999};
    public static final String[] weatherPngs = new String[]{"s_thunder_2.png", "s_thunder_1.png", "s_snowy_4.png", "s_snowy_3.png", "s_snowy_2.png", "s_snowy_1.png", "s_rainy_3.png", "s_rainy_2.png", "s_rainy_1.png", "s_fine_4.png", "s_fine_3.png", "s_fine_2.png", "s_fine_1.png", "s_cloudy_3.png", "s_cloudy_2.png", "s_cloudy_1.png", "l_thunder_3.png", "l_thunder_2.png", "l_thunder_1.png", "l_snowy_5.png", "l_snowy_4.png", "l_snowy_3.png", "l_snowy_2.png", "l_snowy_1.png", "lr5.png", "lr4.png", "lr3.png", "lr2.png", "lr1.png", "l_fine_5.png", "l_fine_4.png", "l_fine_3.png", "l_fine_2.png", "l_fine_1.png", "l_cloudy_3.png", "l_cloudy_2.png", "l_cloudy_1.png", "no_data1.png", "no_data2.png", "no_data3.png"};
    public static int SUN_MIN = 0;
    public static int SUN_MAX = 35;
    public static int CLOUD_MIN = 36;
    public static int CLOUD_MAX = 72;
    public static int UMBRELLA_MIN = 73;
    public static int UMBRELLA_MAX = 98;
    public static int SNOW_MIN = 99;
    public static int SNOW_MAX = 120;
    static final int SLASH = 501;
    static final int ARROW = 502;
    static final int CLOUD = 503;
    static final int UMBRELLA = 504;
    static final int LIGHTNING = 505;
    static final int SNOW = 506;
    static final int SUN = 507;
    static final int[] splitters = new int[]{0, 501, 501, 501, 501, 501, 501, 501, 501, 502, 502, 502, 502, 502, 502, 502, 502, 502, 502, 501, 501, 502, 0, 0, 502, 502, 502, 502, 502, 0, 0, 501, 501, 501, 501, 502, 0, 501, 501, 501, 501, 501, 501, 501, 501, 0, 502, 502, 502, 502, 502, 502, 502, 502, 502, 502, 501, 501, 502, 501, 502, 502, 502, 502, 502, 502, 502, 0, 501, 501, 501, 501, 502, 0, 501, 501, 501, 501, 0, 0, 501, 502, 502, 502, 502, 502, 502, 502, 502, 501, 502, 502, 502, 502, 502, 0, 0, 501, 501, 502, 502, 0, 501, 501, 501, 0, 0, 0, 501, 502, 502, 502, 502, 502, 502, 502, 502, 0, 0, 0, 501, 0};
    static final int[] subImages = new int[]{0, 503, 504, 504, 506, 506, 504, 504, 505, 503, 503, 504, 504, 504, 506, 506, 506, 504, 505, 504, 504, 504, 0, 0, 505, 504, 504, 504, 504, 0, 0, 503, 506, 506, 506, 506, 0, 507, 504, 504, 506, 506, 504, 504, 505, 0, 507, 507, 504, 504, 504, 506, 506, 506, 504, 505, 504, 504, 504, 507, 504, 504, 504, 504, 506, 506, 506, 0, 504, 506, 506, 506, 506, 0, 507, 503, 506, 506, 0, 0, 506, 507, 503, 506, 506, 507, 503, 507, 503, 506, 507, 507, 507, 506, 506, 0, 0, 506, 505, 507, 503, 0, 507, 503, 504, 0, 0, 0, 504, 507, 503, 504, 507, 503, 504, 504, 504, 0, 0, 0, 505, 0};
    static final String[] weatherStrings = new String[]{"%17", "fair, partly %16", "fair, intermittent scattered %23", "fair, %05 scattered %23", "%01%04 snow %23", "%01%05 snow %23", "%01%04 %06 %23", "%01%05 %06 %23", "%01%04 %06 %23 and possible %22showers", "%17, with gradually increasing heavy clouds", "%17 %09, then %08ly thickening clouds", "%02then %16 %04 rain %07", "%02then %16 %05 rain %07", "%02then %08 %12 %07", "%02then %16 %04 snow %07", "%02then %16 %05 snow %07", "%02then %08 snowfall %07", "%02then %16 with %08 rain", "%02then %08 rain and %24ied %22storms %07", "%01%04 %12 in both the %18 and %19 %20", "%01%04 %12 in the early %18 %20 only", "%01%04 %12 in the %19 %20 only", "%01with isolated %22%23/storms %00", "%01with isolated snow %23 over hilly and mountainous terrain", "%01with scattered %22%23/storms in the afternoon", "%02then %08ly rainy after noon", "%02then %08ly rainy from the %19 onwards", "%02then %08ly rainy %15 %19", "fair for most of the day, then rainy from midnight onwards ", "%18 fog and/or haze, burning-off to become mostly fair", "early %18 fog and haze, then fair and mostly %17", "%01%16 %15 %18 and %19 %20", "%01%05 scattered snow fall", "%01intermittent scattered snow fall", "%01%05 scattered snow fall", "%02then rain or snow", "%16 skies", "partly to mostly %16 skies", "%03%21 %04 rain ", "%03%21 %05 rain ", "%21, %04 snowfall", "%21 %05 snowfall", "%16, %04 rain", "%16, %05 rain or snow", "%16, intermittent rain - %22shower/storm", "fog", "%03%13 %05ly fair %07", "%16, then %17 %07", "%03%04 rain %07", "%03%05 rain %07", "%03%08 rain %07", "%03%04 snow %07", "%03%05 snow %07", "%03with %08 snow %07", "%03with %08 rain %07", "%03with %08 rain %07 %24ied by %22%23/storms", "%03%04 %12 in both the %18 and %19 %20", "%03%04 %12 in the early %18 %20 only ", "%03%04 %12 in the %19 %20 only", "%16 %05 sunshine/clear periods", "%16 %09, then %08 rain after noon", "%16 %09, then %08 rain from the %19 onwards", "%16 %09, then %08 rain %15 nighttime %20", "%16 %15 daytime, rain from midnight onward", "%16 %09, then a %08 snowfall from midday onwards ", "%16 %15 daytime, with snow from the %19 onwards", "%16 %15 daytime, with snow during night time %20", "%16 along the coast with misty rain, drizzle or fog", "%03%05 rainy periods with %24ying storms", "%03%05 snowy periods with %22 and lightning", "%03%04 snowfall", "%21, %05 snow or rain", "%03with %08 snowfall %07", "rain", "rain, %05 clear patches", "%06, %21", "rain, mixed with light traces of snow", "rain, %05 snow", "heavy %08 rain", "rainstorm possible causing flooding or wind damages", "rain, intermittent light traces of snow", "rain %09, %05 clear patches %07", "rain %09, with a continuing %21 throughout the day", "rainy %09, %13 %05ly snowy", "rainy %09, %13 snowy", "rainy, %05 snow, %07 fair by the end of the day", "rainy, %05 snow, %07 %16 or %21", "rain %14 then %13 fair", "rain %14 then remaining %16/%21", "rain %14 %04 snow", "rain %09, then gradually clearing to become fair after midday", "rain for most of the day, with some slow clearing towards sunset, then fair in the %19", "rain for most of the day, then clear in the %19", "rain, %13 snow %15 %19", "rain, %13 snow during late night", "rain, at times very heavy; gusty winds possible", "rain, intermittently %13 sleet", "snow, at times mixed with rain", "rain %24ying lightning", "snowy, %05 rain later, clear by the end of the day", "snowy, %05 rain, with all precipitation ending %07, but remaining %16/%21", "snow", "snow, %05 clear skies", "snow %05 pauses, %21", "snow, %05 rain", "heavy %08 snow", "heavy %08 snow, with increasingly strong winds causing snowdrifts; snowstorm", "blizzard - high wind %24ied by great cold and drifting or falling snow", "snow, %04 rain", "snow %09, then %13 fair", "snow %09, ending %07, but remaining %21 or %16", "snow %09, %13 rainy", "snow %14 then %13 fair", "snow %14 then remaining %16/%21", "snow %14 but changing to rain after midday", "snow for most of the day, but changing to rain from the %19 onwards", "snow %15 day, but %13 rain from midnight onwards", "snow, at times very heavy", "snow %09, changing to sleet %07", "snow, %04 sleet", "snow %24ied with %22 and lightning - snow thunderstorm"};
    static final String[] replacements = new String[]{"over hilly or mountainous terrain", "fair, but ", "fair initially, ", "cloudy, but ", "with intermittent", "with occasional", "scattered rain", "later on", "continuous", "initially", "fair, but", "cloudy, but", "rain showers", "becoming", "during the morning hours,", "during the", "cloudy", "sunny", "morning", "evening", "hours", "overcast", "thunder", "showers", "accompan"};

    static int weatherCode2Key(int n) {
        int n2 = 0;
        while (n2 < key2code.length) {
            if (key2code[n2] == n) {
                return n2;
            }
            ++n2;
        }
        return 0;
    }

    public static boolean isSlash(int n) {
        int n2 = WeatherInfo.weatherCode2Key(n);
        return splitters[n2] == 501;
    }

    public static boolean isArrow(int n) {
        int n2 = WeatherInfo.weatherCode2Key(n);
        return splitters[n2] == 502;
    }

    public static String getWeatherConditions(int n) {
        char[] cArray = new char[2];
        int n2 = WeatherInfo.weatherCode2Key(n);
        StringBuffer stringBuffer = new StringBuffer(weatherStrings[n2]);
        int n3 = 0;
        while (n3 < stringBuffer.length()) {
            if (stringBuffer.charAt(n3) == '%') {
                stringBuffer.getChars(n3 + 1, n3 + 3, cArray, 0);
                stringBuffer.delete(n3, n3 + 3);
                int n4 = Integer.parseInt(new String(cArray));
                stringBuffer.insert(n3, replacements[n4]);
                n3 += replacements[n4].length();
                continue;
            }
            ++n3;
        }
        return stringBuffer.toString();
    }

    public static int[] getSubImageBounds(int n) {
        int n2 = WeatherInfo.weatherCode2Key(n);
        int n3 = 0;
        int n4 = 0;
        if (n2 < 0 || n2 > subImages.length) {
            return null;
        }
        switch (subImages[n2]) {
            case 0: {
                return null;
            }
            case 503: {
                n3 = 13;
                n4 = 15;
                break;
            }
            case 507: {
                n3 = 9;
                n4 = 12;
                break;
            }
            case 504: {
                n3 = 6;
                n4 = 8;
                break;
            }
            case 506: {
                n3 = 2;
                n4 = 5;
                break;
            }
            case 505: {
                n3 = 0;
                n4 = 1;
            }
        }
        int[] nArray = new int[]{n3, n4};
        return nArray;
    }

    public static int[] getMainImageBounds(int n) {
        int n2;
        int n3;
        int n4 = WeatherInfo.weatherCode2Key(n);
        if (splitters[n4] == 0) {
            if (n4 <= SUN_MAX) {
                n3 = 29;
                n2 = 33;
            } else if (n4 >= CLOUD_MIN && n4 <= CLOUD_MAX) {
                n3 = 34;
                n2 = 36;
            } else if (n4 >= UMBRELLA_MIN && n4 <= UMBRELLA_MAX) {
                n3 = 24;
                n2 = 28;
            } else if (n4 == 121) {
                n3 = 37;
                n2 = 39;
            } else {
                n3 = 19;
                n2 = 23;
            }
        } else if (n4 <= SUN_MAX) {
            n3 = 9;
            n2 = 12;
        } else if (n4 >= CLOUD_MIN && n4 <= CLOUD_MAX) {
            n3 = 13;
            n2 = 15;
        } else if (n4 >= UMBRELLA_MIN && n4 <= UMBRELLA_MAX) {
            n3 = 6;
            n2 = 8;
        } else {
            n3 = 2;
            n2 = 5;
        }
        int[] nArray = new int[]{n3, n2};
        return nArray;
    }
}

