/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import java.util.Calendar;
import java.util.Date;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.rms.RecordStore;

class WeatherCanvas
extends Canvas
implements Runnable {
    final boolean EMULATOR;
    byte[] hi;
    byte[] lo;
    int[] data;
    String[] date;
    byte[] binaryData;
    static final int BINARY_LENGTH = 320;
    static final int BINARY_OFFSET = 20;
    static final int BINARY_COUNTRY_INC = 25;
    static final int BINARY_DAYS = 8;
    boolean PAINT_HEADER = true;
    boolean PAINT_IMAGEBOX = false;
    boolean PAINT_FOOTER = true;
    boolean PAINT_TEMPS = false;
    boolean PAINT_MAP = true;
    boolean CLEAR_SCREEN;
    static final int LEFT = 0;
    static final int HCENTER = 50;
    static final int RIGHT = 100;
    static final int TOP = 0;
    static final int VCENTER = 40;
    static final int BOTTOM = 79;
    static final int DIV1 = 11;
    static final int DIV2 = 22;
    static final int DIV3 = 70;
    static final String[] COUNTRIES = new String[]{"Honolulu", "Los Angeles", "New York", "Brasilia", "London", "Munich", "Cairo", "Moscow", "Singapore", "Hong Kong", "Beijing", "Sydney"};
    final byte[] screen2Data = new byte[]{10, 7, 8, 9, 0, 1, 6, 2, 4, 3, 5, 11};
    static final int[] TIME_DIFFS = new int[]{-10, -8, -5, -1, 0, 1, 2, 3, 8, 8, 8, 10};
    static int localTimeDiff = 0;
    static final int[] COUNTRY_X = new int[]{1, 13, 27, 28, 49, 52, 55, 59, 77, 79, 80, 89};
    static final int[] COUNTRY_Y = new int[]{36, 33, 28, 50, 21, 23, 40, 26, 45, 37, 28, 58};
    int COUNTRY_PTR = 0;
    static final int MAX_COUNTRY = 11;
    int CURRENT_SCREEN = 0;
    static final int HI_X = 35;
    static final int HI_Y = 32;
    static final int LOW_X = 35;
    static final int LOW_Y = 50;
    static final int MAIN_IMG_X = 5;
    static final int MAIN_IMG_Y = 32;
    static final int SUB_IMG_X = 18;
    static final int SUB_IMG_Y = 46;
    static final int ARROW_X = 5;
    static final int ARROW_Y = 47;
    static final int SLASH_XA = 7;
    static final int SLASH_YA = 56;
    static final int SLASH_XB = 29;
    static final int SLASH_YB = 34;
    int X_ADJUST = 0;
    int Y_ADJUST = 0;
    static final int X_STEP = 10;
    static final int Y_STEP = 2;
    static final long THREAD_SLEEP = 1L;
    static final int IMAGEBOX_SLEEPS = 8;
    static final int FOOTER_SLEEPS = 4;
    static final int MAP_SLEEPS = 1;
    int fPtr;
    String visibleFooterString;
    String mapFooterString;
    String countryFooterString;
    String currentFooterString;
    static final int VISIBLE_FOOTER_LENGTH = 17;
    static final String IMAGE_DIR = "/png/";
    int[] mainImageBounds;
    int[] subImageBounds;
    boolean isSlash;
    boolean isArrow;
    Image[] pngs;
    Image arrowImage;
    int currentMainImg;
    int currentSubImg;
    Image mapImage;
    public static final String MAP_FILE = "/png/map.png";
    static final int X_DELTA = 4;
    int X_MAPJUMPS;
    int CURRENT_MAPX;
    int MAP_DIR;
    boolean MAP_SCROLL_LOCK;
    boolean COUNTRY_SCROLL_LOCK;
    boolean MAP_MODE = true;
    int screenChangeSquareSize;
    boolean SCREEN_CHANGE;
    boolean PAINT_SCREEN_CHANGE;
    Calendar cal;
    String debugString = "start";
    int tripleSquareCount;

    public WeatherCanvas() {
        this.EMULATOR = false;
        this.hi = new byte[9];
        this.lo = new byte[9];
        this.data = new int[9];
        this.date = new String[9];
        this.cal = Calendar.getInstance();
        this.getBinaryData();
        this.getMapInfo();
        this.getCountryData();
        this.fPtr = 0;
        this.pngs = new Image[WeatherInfo.weatherPngs.length];
        try {
            this.arrowImage = Image.createImage((String)"/png/arrow.png");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void getBinaryData() {
        Object[] objectArray;
        boolean bl = false;
        try {
            objectArray = RecordStore.listRecordStores();
            boolean bl2 = false;
            int n = 0;
            while (n < objectArray.length) {
                if (objectArray[n].equals("tenki")) {
                    bl2 = true;
                    break;
                }
                ++n;
            }
            if (bl2) {
                RecordStore recordStore = RecordStore.openRecordStore((String)"tenki", (boolean)false);
                this.binaryData = recordStore.getRecord(1);
                recordStore.closeRecordStore();
                bl = true;
            } else {
                InputStream inputStream = Class.forName("Opening").getResourceAsStream("/dat/w.dat");
                int n2 = inputStream.read(this.binaryData, 0, 320);
                inputStream.close();
                bl = n2 > 0;
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        if (!bl) {
            objectArray = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 1, 54, 2, 1, 0, 0, 0, -31, 37, 6, 32, 0, 1, 0, 0, 0, 1, 1, 1, 1, 1, 3, 4, 5, 6, 16, 17, 17, 15, 22, 25, 27, 26, 23, 20, 20, 23, 2, 1, 1, 0, 0, 0, 1, 1, 1, 12, 10, 10, 9, 11, 12, 12, 10, 26, 26, 25, 28, 27, 24, 20, 25, 3, 66, 66, 1, 66, 1, 1, 1, 1, 15, 11, 12, 12, 11, 12, 11, 11, 19, 17, 16, 17, 18, 19, 21, 18, 4, 1, 66, 66, 66, 66, -128, 67, 67, 28, 26, 25, 25, 25, 26, 25, 26, 33, 30, 29, 29, 29, 29, 30, 31, 5, 64, 1, 1, -86, -86, 64, 1, 65, 24, 25, 25, 25, 25, 24, 26, 24, 31, 31, 31, 30, 29, 30, 31, 30, 6, 66, 0, 0, 64, 66, 0, 67, 1, 21, 19, 18, 20, 21, 16, 18, 17, 25, 28, 29, 31, 27, 24, 26, 27, 7, 0, 0, 1, 1, 0, 1, 1, 1, 22, 19, 20, 24, 23, 22, 21, 21, 35, 35, 33, 33, 32, 31, 30, 32, 8, 1, 0, 0, 0, 64, 1, 1, 1, 16, 17, 18, 17, 18, 18, 18, 17, 23, 24, 26, 27, 24, 24, 24, 24, 9, 64, -86, 1, 1, 1, 1, 1, 1, 19, 20, 19, 20, 20, 20, 21, 20, 25, 27, 28, 28, 28, 28, 28, 28, 10, 1, 1, 1, 1, 1, 0, 1, 1, 16, 18, 18, 19, 18, 18, 20, 18, 29, 29, 29, 29, 29, 31, 29, 29, 11, 0, 1, 72, 72, 72, 72, 66, 65, 24, 23, 21, 22, 21, 22, 23, 21, 31, 28, 28, 29, 28, 27, 26, 27, 12, 65, 0, 0, 0, 1, 67, 1, 1, 10, 10, 9, 9, 10, 10, 9, 9, 21, 19, 18, 19, 20, 19, 17, 18};
            this.binaryData = (byte[])objectArray;
        }
    }

    void newCountryScreen() {
        this.isSlash = false;
        this.isArrow = false;
        this.fPtr = 0;
        this.getImageData(this.data[this.CURRENT_SCREEN]);
        this.CLEAR_SCREEN = true;
    }

    void getMapInfo() {
        this.mapFooterString = "";
        int n = 0;
        int n2 = 0;
        while (n2 <= 11) {
            this.mapFooterString = this.mapFooterString + COUNTRIES[n2] + ":  ";
            n = this.binaryCodeToInteger(this.binaryData[20 + 25 * n2 + 1]);
            this.mapFooterString = this.mapFooterString + WeatherInfo.getWeatherConditions(n) + ", ";
            this.mapFooterString = this.mapFooterString + "LO: " + this.binaryData[20 + 25 * n2 + 8 + 1] + ", HI: " + this.binaryData[20 + 25 * n2 + 16 + 1] + "...   ";
            ++n2;
        }
        try {
            this.mapImage = Image.createImage((String)MAP_FILE);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    int binaryCodeToInteger(byte by) {
        int n;
        if (by == -1) {
            return 999;
        }
        int n2 = (by & 0xC0) >> 6;
        ++n2;
        n2 *= 100;
        int n3 = by & 0x1F;
        if ((by & 0x20) == 0) {
            n = n3;
        } else {
            switch (n3) {
                case 0: {
                    n = 32;
                    break;
                }
                case 8: {
                    n = 40;
                    break;
                }
                case 10: {
                    n = 50;
                    break;
                }
                case 12: {
                    n = 60;
                    break;
                }
                case 13: {
                    n = 61;
                    break;
                }
                case 14: {
                    n = 70;
                    break;
                }
                case 15: {
                    n = 71;
                    break;
                }
                case 17: {
                    n = 81;
                    break;
                }
                default: {
                    return 999;
                }
            }
        }
        return n2 + n;
    }

    public void paint(Graphics graphics) {
        if (this.CLEAR_SCREEN) {
            graphics.setGrayScale(255);
            graphics.fillRect(0 + this.X_ADJUST, 0, 79 + this.X_ADJUST, 100);
            graphics.setGrayScale(0);
            graphics.drawLine(0 + this.X_ADJUST - 1, 22, 0 + this.X_ADJUST - 1, 79);
            graphics.drawLine(100 + this.X_ADJUST + 1, 22, 100 + this.X_ADJUST + 1, 79);
            this.CLEAR_SCREEN = false;
            this.PAINT_HEADER = true;
            this.PAINT_IMAGEBOX = true;
            this.PAINT_FOOTER = true;
            this.PAINT_TEMPS = true;
        }
        if (this.PAINT_HEADER) {
            this.paintHeader(graphics);
            this.PAINT_HEADER = false;
        }
        if (this.PAINT_TEMPS) {
            this.paintTemps(graphics);
            this.PAINT_TEMPS = false;
        }
        if (this.PAINT_IMAGEBOX) {
            this.paintImageBox(graphics);
            this.PAINT_IMAGEBOX = false;
        }
        if (this.PAINT_FOOTER) {
            this.paintFooter(graphics);
            this.PAINT_FOOTER = false;
        }
        if (this.PAINT_MAP) {
            this.paintMap(graphics);
            this.PAINT_MAP = false;
        }
        if (this.PAINT_SCREEN_CHANGE) {
            graphics.fillRect(0, 0, 100, 79);
            this.drawTripleSquare(50, COUNTRY_Y[this.COUNTRY_PTR], this.screenChangeSquareSize, graphics, true);
            this.PAINT_SCREEN_CHANGE = false;
        }
    }

    void paintImageBox(Graphics graphics) {
        graphics.drawImage(this.pngs[this.currentMainImg], 5 + this.X_ADJUST, 32, 20);
        if (this.isSlash) {
            graphics.drawLine(7 + this.X_ADJUST, 56, 29 + this.X_ADJUST, 34);
            graphics.drawImage(this.pngs[this.currentSubImg], 18 + this.X_ADJUST, 46, 20);
        } else if (this.isArrow) {
            graphics.drawImage(this.arrowImage, 5 + this.X_ADJUST, 47, 20);
            graphics.drawImage(this.pngs[this.currentSubImg], 18 + this.X_ADJUST, 46, 20);
        }
    }

    void incImageBox() {
        if (++this.currentMainImg > this.mainImageBounds[1]) {
            this.currentMainImg = this.mainImageBounds[0];
        }
        if ((this.isArrow || this.isSlash) && ++this.currentSubImg > this.subImageBounds[1]) {
            this.currentSubImg = this.subImageBounds[0];
        }
    }

    void paintHeader(Graphics graphics) {
        int n = (this.MAP_MODE ? 11 : 22) + 1;
        graphics.setGrayScale(255);
        int n2 = 0 + this.X_ADJUST >= 0 ? 0 + this.X_ADJUST : 0;
        graphics.fillRect(n2, 0, 100 + this.X_ADJUST, n);
        graphics.setGrayScale(0);
        graphics.drawRect(n2, 0, 100 + this.X_ADJUST, n);
        Font font = Font.getFont((int)64, (int)1, (int)8);
        graphics.setFont(font);
        Date date = new Date();
        date.setTime(date.getTime() + (long)((TIME_DIFFS[this.COUNTRY_PTR] + localTimeDiff) * 60 * 60 * 1000));
        this.cal.setTime(date);
        String string = ":" + (this.cal.get(12) < 10 ? "0" : "") + this.cal.get(12);
        String string2 = this.cal.get(10) + string;
        graphics.drawString(COUNTRIES[this.COUNTRY_PTR] + "   " + string2, 50 + this.X_ADJUST, 2, 17);
        if (!this.MAP_MODE) {
            graphics.drawString(this.date[this.CURRENT_SCREEN], 50 + this.X_ADJUST, 12, 17);
        }
    }

    void paintFooter(Graphics graphics) {
        graphics.setGrayScale(255);
        int n = 0 + this.X_ADJUST >= 0 ? 0 + this.X_ADJUST : 0;
        graphics.fillRect(n, 70, 100 + this.X_ADJUST, 9);
        graphics.setGrayScale(0);
        Font font = Font.getFont((int)64, (int)1, (int)8);
        graphics.setFont(font);
        graphics.drawString(this.visibleFooterString, 0 + this.X_ADJUST, 71, 20);
    }

    void incFooter() {
        if (this.fPtr + 17 < this.currentFooterString.length()) {
            this.visibleFooterString = this.currentFooterString.substring(this.fPtr, this.fPtr + 17);
        } else {
            this.visibleFooterString = this.currentFooterString.substring(this.fPtr);
            int n = this.visibleFooterString.length();
            if (n < 17 && 17 - n < this.currentFooterString.length()) {
                this.visibleFooterString = this.visibleFooterString + this.currentFooterString.substring(0, 17 - n);
            }
        }
        if (++this.fPtr >= this.currentFooterString.length()) {
            this.fPtr = 0;
        }
    }

    void paintTemps(Graphics graphics) {
        graphics.setGrayScale(255);
        int n = 35 + this.X_ADJUST >= 0 ? 35 + this.X_ADJUST : 0;
        graphics.fillRect(n, 24, 100 + this.X_ADJUST, 46);
        graphics.setGrayScale(0);
        Font font = Font.getFont((int)64, (int)1, (int)16);
        graphics.setFont(font);
        graphics.drawString("High: " + this.hi[this.CURRENT_SCREEN] + " C", 35 + this.X_ADJUST, 32, 20);
        graphics.drawString("Low: " + this.lo[this.CURRENT_SCREEN] + " C", 35 + this.X_ADJUST, 50, 20);
        font = Font.getFont((int)64, (int)1, (int)8);
        graphics.setFont(font);
    }

    void paintMap(Graphics graphics) {
        if (this.X_MAPJUMPS > 4) {
            this.CURRENT_MAPX += 4 * this.MAP_DIR;
            this.X_MAPJUMPS -= 4;
        } else if (this.X_MAPJUMPS > 0) {
            this.CURRENT_MAPX += this.MAP_DIR;
            --this.X_MAPJUMPS;
        } else if (this.CURRENT_MAPX == COUNTRY_X[this.COUNTRY_PTR]) {
            this.MAP_SCROLL_LOCK = false;
        } else {
            this.MAP_DIR = COUNTRY_X[this.COUNTRY_PTR] > this.CURRENT_MAPX ? 1 : -1;
            this.X_MAPJUMPS = COUNTRY_X[this.COUNTRY_PTR] - this.CURRENT_MAPX;
            this.X_MAPJUMPS *= this.X_MAPJUMPS > 0 ? 1 : -1;
        }
        graphics.setGrayScale(255);
        graphics.fillRect(0, 13, 100, 57);
        graphics.setGrayScale(0);
        graphics.drawImage(this.mapImage, 50 - this.CURRENT_MAPX, 13, 20);
        int n = this.CURRENT_MAPX > 50 ? 50 - this.CURRENT_MAPX + 100 : 50 - this.CURRENT_MAPX - 100;
        graphics.drawImage(this.mapImage, n, 13, 20);
        if (!this.MAP_SCROLL_LOCK) {
            this.drawTripleSquare(50, COUNTRY_Y[this.COUNTRY_PTR], 12, graphics, true);
            graphics.drawArc(48, COUNTRY_Y[this.COUNTRY_PTR] - 2, 5, 5, 0, 360);
            graphics.fillArc(50, COUNTRY_Y[this.COUNTRY_PTR], 1, 1, 0, 360);
        } else {
            if (this.X_MAPJUMPS > 7) {
                this.drawTripleSquare(50, COUNTRY_Y[this.COUNTRY_PTR], 32, graphics, false);
            } else {
                switch (this.X_MAPJUMPS) {
                    case 6: 
                    case 7: {
                        this.drawTripleSquare(50, COUNTRY_Y[this.COUNTRY_PTR], 28, graphics, false);
                        break;
                    }
                    case 4: 
                    case 5: {
                        this.drawTripleSquare(50, COUNTRY_Y[this.COUNTRY_PTR], 24, graphics, false);
                        break;
                    }
                    case 2: 
                    case 3: {
                        this.drawTripleSquare(50, COUNTRY_Y[this.COUNTRY_PTR], 20, graphics, false);
                        break;
                    }
                    case 0: 
                    case 1: {
                        this.drawTripleSquare(50, COUNTRY_Y[this.COUNTRY_PTR], 16, graphics, false);
                    }
                }
            }
            this.PAINT_HEADER = true;
        }
    }

    void drawTripleSquare(int n, int n2, int n3, Graphics graphics, boolean bl) {
        graphics.setGrayScale(0);
        graphics.drawRect(n - n3 / 2, n2 - n3 / 2, n3, n3);
        graphics.drawRect(n + 2 - n3 / 2, n2 + 2 - n3 / 2, n3 - 4, n3 - 4);
        graphics.setGrayScale(255);
        graphics.drawRect(n + 1 - n3 / 2, n2 + 1 - n3 / 2, n3 - 2, n3 - 2);
        if (bl) {
            graphics.fillRect(n + 1 - n3 / 2, n2 + 1 - n3 / 2, n3 - 2, n3 - 2);
        }
        graphics.setGrayScale(0);
    }

    protected void keyPressed(int n) {
        switch (this.getGameAction(n)) {
            case 2: {
                if (this.MAP_MODE) {
                    if (this.MAP_SCROLL_LOCK) break;
                    if (this.COUNTRY_PTR == 0) {
                        this.COUNTRY_PTR = 11;
                        this.CURRENT_MAPX += 100;
                        this.X_MAPJUMPS = 100 - COUNTRY_X[this.COUNTRY_PTR] + COUNTRY_X[0];
                        this.MAP_DIR = -1;
                    } else {
                        --this.COUNTRY_PTR;
                    }
                    this.MAP_SCROLL_LOCK = true;
                    break;
                }
                if (this.COUNTRY_SCROLL_LOCK || this.CURRENT_SCREEN <= 0) break;
                --this.CURRENT_SCREEN;
                this.newCountryScreen();
                this.X_ADJUST = -100;
                this.COUNTRY_SCROLL_LOCK = true;
                break;
            }
            case 5: {
                if (this.MAP_MODE) {
                    if (this.MAP_SCROLL_LOCK) break;
                    if (this.COUNTRY_PTR == 11) {
                        this.COUNTRY_PTR = 0;
                        this.CURRENT_MAPX -= 100;
                        this.X_MAPJUMPS = 100 - COUNTRY_X[11] + COUNTRY_X[0];
                        this.MAP_DIR = 1;
                    } else {
                        ++this.COUNTRY_PTR;
                    }
                    this.MAP_SCROLL_LOCK = true;
                    break;
                }
                if (this.COUNTRY_SCROLL_LOCK || this.CURRENT_SCREEN >= 7) break;
                ++this.CURRENT_SCREEN;
                this.newCountryScreen();
                this.X_ADJUST = 100;
                this.COUNTRY_SCROLL_LOCK = true;
                break;
            }
            case 1: 
            case 6: {
                this.SCREEN_CHANGE = true;
                this.screenChangeSquareSize = this.MAP_MODE ? 0 : 125;
            }
        }
    }

    void switchMode() {
        this.X_ADJUST = 0;
        this.MAP_MODE = !this.MAP_MODE;
        this.fPtr = 0;
        String string = this.currentFooterString = this.MAP_MODE ? this.mapFooterString : this.countryFooterString;
        if (!this.MAP_MODE) {
            this.getCountryData();
        }
        this.CLEAR_SCREEN = true;
        this.CURRENT_SCREEN = 0;
        this.PAINT_MAP = this.MAP_MODE;
    }

    public void run() {
        int n = 0;
        int n2 = 100;
        while (true) {
            if (this.X_ADJUST != 0) {
                this.X_ADJUST += 10 * (this.X_ADJUST > 0 ? -1 : 1);
                this.CLEAR_SCREEN = true;
            }
            if (this.COUNTRY_SCROLL_LOCK && this.X_ADJUST == 0) {
                this.COUNTRY_SCROLL_LOCK = false;
            }
            if (this.Y_ADJUST != 0) {
                this.Y_ADJUST += 2 * (this.Y_ADJUST > 0 ? -1 : 1);
                this.CLEAR_SCREEN = true;
            }
            if (this.MAP_MODE) {
                if (n % 1 == 0) {
                    this.PAINT_MAP = true;
                }
            } else {
                if (n % 8 == 0) {
                    this.PAINT_TEMPS = true;
                }
                if (n % 8 == 0) {
                    this.incImageBox();
                    this.PAINT_IMAGEBOX = true;
                }
            }
            if (this.SCREEN_CHANGE) {
                if (this.MAP_MODE) {
                    this.screenChangeSquareSize += 10;
                    if (this.screenChangeSquareSize > 125) {
                        this.SCREEN_CHANGE = false;
                        this.PAINT_SCREEN_CHANGE = false;
                        this.switchMode();
                    } else {
                        this.PAINT_SCREEN_CHANGE = true;
                    }
                } else {
                    this.screenChangeSquareSize -= 10;
                    if (this.screenChangeSquareSize <= 12) {
                        this.SCREEN_CHANGE = false;
                        this.PAINT_SCREEN_CHANGE = false;
                        this.switchMode();
                    } else {
                        this.PAINT_SCREEN_CHANGE = true;
                    }
                }
            }
            if (n % 4 == 0) {
                this.incFooter();
                this.PAINT_FOOTER = true;
            }
            if (n % 8 == 0) {
                this.PAINT_HEADER = true;
            }
            this.repaint();
            if (++n > n2) {
                n = 0;
            }
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    public void setLocalTimeDiff(int n) {
        if (n <= 14 && n >= -12) {
            localTimeDiff = n;
        }
    }

    void getCountryData() {
        int n = 20 + 25 * this.screen2Data[this.COUNTRY_PTR] + 1;
        int n2 = 0;
        while (n2 < 8) {
            this.data[n2] = this.binaryCodeToInteger(this.binaryData[n + n2]);
            this.lo[n2] = this.binaryData[n + n2 + 8];
            this.hi[n2] = this.binaryData[n + n2 + 16];
            ++n2;
        }
        long l = (TIME_DIFFS[this.COUNTRY_PTR] + localTimeDiff) * 60 * 60 * 1000;
        Date date = new Date();
        long l2 = System.currentTimeMillis();
        n2 = 0;
        while (n2 <= 8) {
            date.setTime(l2 + l + (long)n2 * 86400000L);
            this.cal.setTime(date);
            String string = n2 == 0 ? "Today" : (n2 == 1 ? "Tomorrow" : this.getDayOfWeekString(this.cal.get(7)));
            int n3 = this.cal.get(2) + 1;
            this.date[n2] = string + ", " + n3 + "/" + this.cal.get(5);
            ++n2;
        }
        this.getImageData(this.data[this.CURRENT_SCREEN]);
    }

    String getDayOfWeekString(int n) {
        switch (n) {
            case 2: {
                return "Monday";
            }
            case 3: {
                return "Tuesday";
            }
            case 4: {
                return "Wednesday";
            }
            case 5: {
                return "Thursday";
            }
            case 6: {
                return "Friday";
            }
            case 7: {
                return "Saturday";
            }
            case 1: {
                return "Sunday";
            }
        }
        return "";
    }

    void getImageData(int n) {
        this.countryFooterString = WeatherInfo.getWeatherConditions(n) + "...  ";
        while (this.countryFooterString.length() < 17) {
            this.countryFooterString = this.countryFooterString + "   ";
        }
        this.currentFooterString = this.MAP_MODE ? this.mapFooterString : this.countryFooterString;
        this.incFooter();
        WeatherCanvas$ImageLoader weatherCanvas$ImageLoader = new WeatherCanvas$ImageLoader(this, n);
        Thread thread = new Thread(weatherCanvas$ImageLoader);
        thread.start();
    }
}

