/*
 * Decompiled with CFR 0.152.
 */
package mil;

import com.siemens.mp.game.Light;
import com.siemens.mp.game.Vibrator;
import java.util.Random;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import mil.Mil;
import mil.MilImCache;
import mil.TriggerAble;

public class MilGame
extends Canvas
implements TriggerAble {
    static Graphics g;
    static Image sImg;
    public static int sSWidth;
    public static int sSHeight;
    private static MilImCache sImCache;
    static final byte cEmpty = 0;
    static final byte cStone = 1;
    static final byte cFStone = 2;
    static final byte cBlock = 3;
    static final byte cMud = 4;
    static final byte cDiamond = 5;
    static final byte cBomb3 = 6;
    static final byte cBomb2 = 7;
    static final byte cBomb1 = 8;
    static final byte cExplo = 9;
    static final byte cPreExp = 10;
    static final byte cBadGuy = 11;
    public static int sWidth;
    public static int sHeight;
    public static int sSize;
    public static byte[] sField;
    public static byte[] sXField;
    public static int sX;
    public static int sY;
    public static int sPos;
    public static int sLives;
    public static int sScore;
    public static int sLevel;
    public static boolean sPaused;
    public static boolean sDied;
    public static boolean sSplash;
    public static int sDX;
    public static int sDY;
    public static int sBadX;
    public static int sBadY;
    public static int sBadPos;
    static final String cSBomb1 = "1";
    static final String cSBomb2 = "2";
    static final String cSBomb3 = "3";
    public static int sRemain;
    public static boolean sPaint;
    public static boolean sRumble;
    public static boolean sRepaint;
    public static int sPaintScore;
    public static int sEvTrig;
    public static long sNextSeed;

    MilGame(int n, int n2, long l, boolean bl, MilImCache milImCache) {
        this.addCommand(Mil.sCmdHelp);
        this.addCommand(Mil.sCmdKey);
        this.addCommand(Mil.sCmdEnd);
        this.setCommandListener(Mil.sMil);
        sImCache = milImCache;
        sScore = 0;
        this.init(n, n2, l, bl);
    }

    public synchronized void init(int n, int n2, long l, boolean bl) {
        Random random;
        if (bl) {
            random = new Random(l);
        } else {
            random = new Random();
            l = random.nextInt();
            random = new Random(l);
        }
        sNextSeed = Integer.MAX_VALUE & (l ^ (long)random.nextInt());
        Mil.sSeed = l;
        Mil.sUseSeed = true;
        Mil.sLevel = n2;
        Mil.sIsRunning = true;
        sLives = n;
        sLevel = n2;
        sRemain = 0;
        sPaused = false;
        sSWidth = this.getWidth();
        sSHeight = this.getHeight();
        sImg = Image.createImage((int)sSWidth, (int)sSHeight);
        g = sImg.getGraphics();
        sDX = sSWidth / 5;
        sDY = (sSHeight - 15) / 5;
        sWidth = n2 + 5 + (random.nextInt() & 7);
        sHeight = n2 + 5 + (random.nextInt() & 7);
        sRumble = false;
        if (sWidth > 15) {
            sWidth = 15;
        }
        if (sHeight > 15) {
            sHeight = 15;
        }
        sSize = sWidth * sHeight;
        sField = new byte[sSize];
        sXField = new byte[25];
        sEvTrig = 0;
        int n3 = sSize - 1;
        while (n3 > 2) {
            MilGame.sField[n3] = (byte)(random.nextInt() & 7);
            if (sField[n3] > 5) {
                int n4 = n3;
                sField[n4] = (byte)(sField[n4] - 5);
            }
            switch (sField[n3]) {
                case 2: {
                    MilGame.sField[n3] = 4;
                }
                case 1: {
                    if (n3 + sWidth >= sSize || sField[n3 + sWidth] != 0) break;
                    MilGame.sField[n3] = 4;
                    break;
                }
                case 5: {
                    if (n3 == sWidth || n3 == sWidth + 1) break;
                    ++sRemain;
                    break;
                }
            }
            --n3;
        }
        MilGame.sField[0] = 0;
        MilGame.sField[1] = 0;
        MilGame.sField[MilGame.sWidth] = 0;
        MilGame.sField[MilGame.sWidth + 1] = 0;
        sX = 0;
        sY = 0;
        sPos = 0;
        sRepaint = true;
        sPaint = true;
        this.sync();
        this.update();
        MilGame.score();
        this.level();
    }

    public void showNotify() {
        sPaint = true;
    }

    public void trigger() {
        if (sPaused) {
            return;
        }
        if (sDied || sSplash) {
            if (sEvTrig++ < 100) {
                return;
            }
            if (sLives < 0) {
                Mil.sIsRunning = false;
                Mil.sIsRunning = false;
                Mil.sMil.commandAction(Mil.sCmdOk, null);
            } else {
                sEvTrig = 0;
                sDied = false;
                sSplash = false;
                sRepaint = true;
                return;
            }
        }
        if (sEvTrig++ == 32) {
            sEvTrig = 0;
        }
        int n = sSize - 1;
        while (n >= 0) {
            switch (sField[n]) {
                case 11: {
                    if ((sEvTrig & 5) != 5) break;
                    if (sX < sBadX && sField[n - 1] == 0) {
                        sBadPos = --sBadX * sWidth * sBadY;
                        MilGame.sField[n] = 0;
                        MilGame.sField[n - 1] = 11;
                        sRepaint = true;
                        if (sPos != sBadPos) break;
                        this.die();
                        break;
                    }
                    if (sX > sBadX && sField[n + 1] == 0) {
                        sBadPos = ++sBadX * sWidth * sBadY;
                        MilGame.sField[n] = 0;
                        MilGame.sField[n + 1] = 11;
                        sRepaint = true;
                        if (sPos != sBadPos) break;
                        this.die();
                        break;
                    }
                    if (sY < sBadY && sField[n - sWidth] == 0) {
                        sBadPos = sBadX * sWidth * --sBadY;
                        MilGame.sField[n] = 0;
                        MilGame.sField[n - MilGame.sWidth] = 11;
                        sRepaint = true;
                        if (sPos != sBadPos) break;
                        this.die();
                        break;
                    }
                    if (sY <= sBadY || sField[n + sWidth] != 0) break;
                    sBadPos = sBadX * sWidth * ++sBadY;
                    MilGame.sField[n] = 0;
                    MilGame.sField[n + MilGame.sWidth] = 11;
                    sRepaint = true;
                    if (sPos != sBadPos) break;
                    this.die();
                    break;
                }
                case 1: {
                    if (n + sWidth >= sSize || sField[n + sWidth] != 0 || sPos == n + sWidth) break;
                    MilGame.sField[n] = 0;
                    MilGame.sField[n + MilGame.sWidth] = 2;
                    sRepaint = true;
                    break;
                }
                case 2: {
                    if ((sEvTrig & 1) == 1) {
                        if (n + sWidth >= sSize) break;
                        if (sField[n + sWidth] == 0 || sField[n + sWidth] == 11) {
                            MilGame.sField[n] = 0;
                            if (sPos == n + sWidth) {
                                MilGame.sField[n + MilGame.sWidth] = 1;
                                this.die();
                            } else {
                                MilGame.sField[n + MilGame.sWidth] = 2;
                            }
                            sRepaint = true;
                            break;
                        }
                        sRumble = true;
                        MilGame.sField[n] = 1;
                        sRepaint = true;
                        break;
                    }
                }
                case 6: 
                case 7: {
                    if ((sEvTrig & 7) != 7) break;
                    int n2 = n;
                    sField[n2] = (byte)(sField[n2] + 1);
                    sRepaint = true;
                    break;
                }
                case 8: {
                    if ((sEvTrig & 7) != 7) break;
                    MilGame.sField[n] = 9;
                    if (n == sPos) {
                        this.die();
                    }
                    if (n - sWidth > 0) {
                        if (sField[n - sWidth] == 5) {
                            --sRemain;
                        }
                        MilGame.sField[n - MilGame.sWidth] = 10;
                        if (n - sWidth == sPos) {
                            this.die();
                        }
                    }
                    if (n - 1 > 0) {
                        if (sField[n - 1] == 5) {
                            --sRemain;
                        }
                        MilGame.sField[n - 1] = 10;
                        if (n - 1 == sPos) {
                            this.die();
                        }
                    }
                    if (n + 1 < sSize) {
                        if (sField[n + 1] == 5) {
                            --sRemain;
                        }
                        MilGame.sField[n + 1] = 9;
                        if (n + 1 == sPos) {
                            this.die();
                        }
                    }
                    if (n + sWidth < sSize) {
                        if (sField[n + sWidth] == 5) {
                            --sRemain;
                        }
                        MilGame.sField[n + MilGame.sWidth] = 9;
                        if (n + sWidth == sPos) {
                            this.die();
                        }
                    }
                    sRepaint = true;
                    sRumble = true;
                    break;
                }
                case 10: {
                    MilGame.sField[n] = 9;
                    sRumble = true;
                    break;
                }
                case 9: {
                    MilGame.sField[n] = 0;
                    sRepaint = true;
                    break;
                }
            }
            --n;
        }
        if (sRumble) {
            Vibrator.triggerVibrator((int)30);
            sRumble = false;
        }
        if (sRemain == 0 & !sSplash) {
            sSplash = true;
            this.init(sLives, sLevel + 1, sNextSeed, true);
        } else if (sRepaint) {
            this.sync();
        }
    }

    protected void keyRepeated(int n) {
        this.checkMove(n);
    }

    protected void keyPressed(int n) {
        this.checkMove(n);
    }

    protected void checkMove(int n) {
        if (sDied || sSplash) {
            return;
        }
        if (sPaused) {
            if (n == 53) {
                Light.setLightOn();
                sPaused = false;
                sRepaint = true;
                return;
            }
            return;
        }
        int n2 = this.getGameAction(n);
        switch (n2) {
            case 1: {
                this.move(2);
                break;
            }
            case 5: {
                this.move(1);
                break;
            }
            case 6: {
                this.move(3);
                break;
            }
            case 2: {
                this.move(0);
                break;
            }
        }
        switch (n) {
            case 50: {
                this.move(2);
                break;
            }
            case 54: {
                this.move(1);
                break;
            }
            case 56: {
                this.move(3);
                break;
            }
            case 52: {
                this.move(0);
                break;
            }
            case 57: {
                this.move(4);
                break;
            }
            case 55: {
                this.move(5);
                break;
            }
            case 53: {
                this.paused();
                break;
            }
            case 51: {
                this.level();
            }
        }
    }

    public synchronized void move(int n) {
        int n2;
        int n3 = sX;
        int n4 = sY;
        switch (n) {
            case 0: {
                if (--n3 >= 0) break;
                return;
            }
            case 1: {
                if (++n3 < sWidth) break;
                return;
            }
            case 2: {
                if (--n4 >= 0) break;
                return;
            }
            case 3: {
                if (++n4 < sHeight) break;
                return;
            }
            case 4: {
                MilGame.sField[MilGame.sPos] = 6;
                this.setScore(-300);
                sRepaint = true;
                this.sync();
                return;
            }
            case 5: {
                this.setScore(-200);
                MilGame.sField[MilGame.sPos] = 9;
                n3 = sWidth - n3 - 1;
                if (n3 == sX) {
                    --n3;
                }
                if ((n4 = sHeight - n4 - 1) == sY) {
                    --n4;
                }
                if ((n2 = n3 + n4 * sWidth) > -1 && n2 < sSize) {
                    if (sField[n2] != 1 && sField[n2] != 2 && sField[n2] != 3) break;
                    MilGame.sField[n2] = 0;
                    break;
                }
                n3 = 0;
                n4 = 0;
            }
        }
        n2 = n3 + sWidth * n4;
        switch (sField[n2]) {
            case 11: {
                sX = n3;
                sY = n4;
                sPos = n2;
                MilGame.sField[n2] = 0;
                this.die();
                break;
            }
            case 3: {
                break;
            }
            case 1: 
            case 2: {
                if (n == 1 && n3 < sWidth - 1 && sField[n2 + 1] == 0) {
                    MilGame.sField[n2 + 1] = 1;
                    sX = n3;
                    sY = n4;
                    sPos = n2;
                    MilGame.sField[n2] = 0;
                    sRepaint = true;
                    this.sync();
                    break;
                }
                if (n != 0 || n3 <= 0 || sField[n2 - 1] != 0) break;
                MilGame.sField[n2 - 1] = 1;
                sX = n3;
                sY = n4;
                sPos = n2;
                MilGame.sField[n2] = 0;
                sRepaint = true;
                this.sync();
                break;
            }
            case 5: {
                --sRemain;
                this.setScore(110);
            }
            case 4: {
                this.setScore(-10);
            }
            default: {
                sX = n3;
                sY = n4;
                sPos = n2;
                MilGame.sField[n2] = 0;
                sRepaint = true;
                this.sync();
            }
        }
    }

    public void paint(Graphics graphics) {
        if (sPaint) {
            graphics.drawImage(sImg, 0, 0, 20);
            graphics.drawImage(sImg, 0, 0, 20);
            sPaint = false;
        }
    }

    public synchronized void sync() {
        if (sRepaint) {
            int n = sX - 2;
            int n2 = sY - 2;
            int n3 = 0;
            while (n3 < 25) {
                MilGame.sXField[n3] = n > -1 && n2 > -1 && n < sWidth && n2 < sHeight ? sField[n + sWidth * n2] : 3;
                if (++n == sX + 3) {
                    n = sX - 2;
                    ++n2;
                }
                ++n3;
            }
            this.update();
        }
    }

    public synchronized void level() {
        if (g != null) {
            int n = g.getColor();
            g.setColor(255, 255, 255);
            g.fillRect(1, sSHeight / 2 - 20, sSWidth - 2, 30);
            g.setColor(1);
            g.drawRect(1, sSHeight / 2 - 20, sSWidth - 2, 30);
            sEvTrig = 0;
            g.drawString(Mil.sL.ggLe() + String.valueOf(sLevel), 25, sSHeight / 2 - 5, 0);
            g.drawString(Mil.sL.ggCo() + String.valueOf(Mil.sSeed), 8, sSHeight / 2 + 8, 0);
            sPaint = true;
            sSplash = true;
            this.repaint();
        }
    }

    public synchronized void die() {
        Vibrator.triggerVibrator((int)200);
        --sLives;
        sX = 0;
        sY = 0;
        sPos = 0;
        this.sync();
        int n = g.getColor();
        g.setColor(255, 255, 255);
        g.fillRect(sSWidth / 2 - 35, sSHeight / 2 - 10, 70, 16);
        g.setColor(n);
        g.drawRect(sSWidth / 2 - 35, sSHeight / 2 - 10, 70, 16);
        sEvTrig = 0;
        if (sLives >= 0) {
            g.drawString(Mil.sL.ggDie(), sSWidth / 2 - 30, sSHeight / 2 + 4, 0);
            sDied = true;
            sSplash = true;
            MilGame.score();
            sPaint = true;
            this.repaint();
        } else {
            g.drawString(Mil.sL.ggGo(), sSWidth / 2 - 26, sSHeight / 2 + 4, 0);
            sDied = true;
            MilGame.score();
            sPaint = true;
            sSplash = true;
            this.repaint();
        }
    }

    public static void clear() {
        int n = g.getColor();
        g.setColor(255, 255, 255);
        g.fillRect(0, 0, sSWidth, sDY * 5 + 1);
        g.setColor(n);
    }

    public void setScore(int n) {
        sPaintScore += n;
    }

    public void paused() {
        Light.setLightOff();
        sPaused = true;
        int n = g.getColor();
        g.setColor(255, 255, 255);
        g.fillRect(sSWidth / 2 - 32, sSHeight / 2 - 10, 64, 16);
        g.setColor(n);
        g.drawRect(sSWidth / 2 - 32, sSHeight / 2 - 10, 64, 16);
        g.drawString(Mil.sL.ggPau(), sSWidth / 2 - 26, sSHeight / 2 + 4, 0);
        sPaint = true;
        this.repaint();
    }

    public static void score() {
        if (g != null) {
            g.setColor(1);
            g.setFont(Font.getFont((int)64, (int)0, (int)8));
            int n = sDY * 5 + 2;
            int n2 = g.getColor();
            g.setColor(255, 255, 255);
            if (sPaintScore != 0) {
                g.fillRect(sSWidth / 2 - 17, 0, 34, 15);
            }
            g.fillRect(0, n, sSWidth, sSHeight - n);
            g.setColor(n2);
            if (sPaintScore != 0) {
                g.drawRect(sSWidth / 2 - 17, 0, 34, 15);
                g.drawString(String.valueOf(sPaintScore), sSWidth / 2 - 10, 14, 0);
                sScore += sPaintScore;
                sPaintScore = 0;
            }
            g.drawLine(0, n, sSWidth, n);
            g.drawImage(sImCache.getMan(0), 2, n + 1, 20);
            g.drawString(String.valueOf(sLives), 12, sSHeight, 0);
            g.drawString("$ " + String.valueOf(sScore), 25, sSHeight, 0);
            g.drawImage(sImCache.getDiamond(0), sSWidth - 30, n + 3, 20);
            g.drawString(String.valueOf(sRemain), sSWidth - 20, sSHeight, 0);
        }
    }

    public synchronized void update() {
        if (sRepaint && g != null && !sPaused && !sDied) {
            MilGame.clear();
            g.setColor(1);
            g.setFont(Font.getFont((int)64, (int)0, (int)8));
            g.drawImage(sImCache.getMan(0), sDX * 2 + 6, 2 * sDY + 1, 20);
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            while (n3 < 25) {
                switch (sXField[n3]) {
                    case 11: {
                        g.drawImage(sImCache.getMan(0), n + 6, n2 + 1, 20);
                        break;
                    }
                    case 8: {
                        g.drawString(cSBomb1, n + 7, n2 + 13, 0);
                        break;
                    }
                    case 7: {
                        g.drawString(cSBomb2, n + 7, n2 + 13, 0);
                        break;
                    }
                    case 6: {
                        g.drawString(cSBomb3, n + 7, n2 + 13, 0);
                        break;
                    }
                    case 9: {
                        g.drawImage(sImCache.getExplosion(), n, n2, 20);
                        break;
                    }
                    case 1: 
                    case 2: {
                        g.drawImage(sImCache.getStone(), n + 3, n2 + 2, 20);
                        break;
                    }
                    case 4: {
                        g.drawImage(sImCache.getMud(), n + 1, n2 + 1, 20);
                        break;
                    }
                    case 3: {
                        g.drawImage(sImCache.getBlock(), n + 1, n2 + 1, 20);
                        break;
                    }
                    case 5: {
                        g.drawImage(sImCache.getDiamond(0), n + 6, n2 + 4, 20);
                        break;
                    }
                }
                if ((n += sDX) == 5 * sDX) {
                    n = 0;
                    n2 += sDY;
                }
                ++n3;
            }
            sRepaint = false;
            if (sPaintScore != 0) {
                MilGame.score();
            }
            sPaint = true;
            this.repaint();
        }
    }
}

