/*
 * Decompiled with CFR 0.152.
 */
package BalloonShooter;

import BalloonShooter.MyResource;

class MyGraphics {
    private static final boolean USE_RESOURCE = true;
    static byte[] m_TailPixels;
    static byte[] m_CrossHairPixels;
    static byte[] m_CrossHairMask;
    static byte[] m_TopPixels;
    static byte[] m_FontPixels;
    static byte[] m_FontMask;
    static byte[] m_Balloon16Pixels;
    static byte[] m_Balloon12Pixels;
    static byte[] m_Balloon8Pixels;
    static byte[] m_Balloon16Mask;
    static byte[] m_Balloon12Mask;
    static byte[] m_Balloon8Mask;

    MyGraphics() {
    }

    static void loadGraphicsForGame(MyResource myResource) {
        System.gc();
        m_CrossHairPixels = myResource.getFile("chair.bin");
        m_CrossHairMask = myResource.getFile("chair.mask");
        m_TopPixels = myResource.getFile("top.bin");
        m_FontPixels = myResource.getFile("font.bin");
        m_FontMask = myResource.getFile("font.mask");
        m_Balloon16Pixels = myResource.getFile("bal16.bin");
        m_Balloon12Pixels = myResource.getFile("bal12.bin");
        m_Balloon8Pixels = myResource.getFile("bal8.bin");
        m_Balloon16Mask = myResource.getFile("bal16.mask");
        m_Balloon12Mask = myResource.getFile("bal12.mask");
        m_Balloon8Mask = myResource.getFile("bal8.mask");
        System.gc();
    }

    static void freeGraphicsForGame() {
        m_Balloon16Mask = null;
        m_Balloon12Mask = null;
        m_Balloon8Mask = null;
        m_Balloon16Pixels = null;
        m_Balloon12Pixels = null;
        m_Balloon8Pixels = null;
        m_FontMask = null;
        m_FontPixels = null;
        m_TopPixels = null;
        m_CrossHairPixels = null;
        m_CrossHairMask = null;
        System.gc();
    }

    static byte[] getTailPixels() {
        return m_TailPixels;
    }

    static byte[] getTailMask() {
        return m_TailPixels;
    }

    static byte[] getCrossHairPixels() {
        return m_CrossHairPixels;
    }

    static byte[] getCrossHairMask() {
        return m_CrossHairMask;
    }

    static byte[] getTopPixels() {
        return m_TopPixels;
    }

    static byte[] getFontPixels() {
        return m_FontPixels;
    }

    static byte[] getFontMask() {
        return m_FontMask;
    }

    static byte[] getBalloonPixels(int n) {
        if (n == 0) {
            return m_Balloon16Pixels;
        }
        if (n == 1) {
            return m_Balloon12Pixels;
        }
        return m_Balloon8Pixels;
    }

    static byte[] getBalloonMask(int n) {
        if (n == 0) {
            return m_Balloon16Mask;
        }
        if (n == 1) {
            return m_Balloon12Mask;
        }
        return m_Balloon8Mask;
    }
}

