/*
 * Decompiled with CFR 0.152.
 */
package BalloonShooter;

import BalloonShooter.BalloonShooter;
import BalloonShooter.Layer;
import BalloonShooter.Local;
import BalloonShooter.MyGraphics;
import BalloonShooter.MyResource;
import BalloonShooter.MyScreen;
import BalloonShooter.RMSData;
import com.siemens.mp.game.ExtendedImage;
import com.siemens.mp.game.GraphicObject;
import com.siemens.mp.game.GraphicObjectManager;
import com.siemens.mp.game.Sound;
import com.siemens.mp.game.Sprite;
import com.siemens.mp.game.Vibrator;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

class GameScreen
extends MyScreen {
    public static final int CURSOR_SPEED = 20;
    public int m_nScore;
    public int m_nLastScore;
    public int m_nLivesLeft;
    public int crossX;
    public int crossY;
    public boolean m_bGameOver;
    static final int[] yVels = new int[]{10, 20, 30};
    static final int[] LevelInfoTime = new int[]{30, 30, 20, 20, 20, 20, 20, 10, 10, 10, 10, 10, 10, 10};
    static final int[] LevelInfoLayers = new int[]{1, 2, 2, 3, 3, 3, 3, 1, 2, 3, 3, 3, 3, 3};
    static final int[] LevelInfoScore = new int[]{0, 100, 300, 600, 1000, 1500, 2100, 2800, 3600, 4500, 5500, 6600, 7800, 9100};
    static final int[] LevelInfoBalloons = new int[]{2, 2, 3, 3, 4, 4, 5, 2, 3, 3, 5, 5, 6, 7};
    public int m_nOldTime;
    public boolean m_bRunning;
    private boolean m_bReadyToPaint = false;
    private static final int GAME_SCREEN_WIDTH = 104;
    private static final int GAME_SCREEN_VIEW_WIDTH = 101;
    private static final int GAME_SCREEN_HEIGHT = 80;
    private Image gameScreenImage;
    private ExtendedImage gameScreen = null;
    private GraphicObjectManager gfxManager;
    private GraphicObjectManager scoreManager;
    private Layer[] BalloonLayers;
    private int m_nFrameCounter;
    private int m_nLevel;
    private int m_nTopPixelsY;
    private static final int PRESSED = 1;
    private static final int RELEASED = 0;
    private static final int REPEATED = 2;
    private Sprite crossHair;
    private Sprite numLivesSpr;
    private Sprite score0Spr;
    private Sprite score1Spr;
    private Sprite score2Spr;
    private Sprite score3Spr;
    private RMSData m_ExternData;

    private void playSound() {
        Sound.playTone((int)240, (int)50);
    }

    private void createCrossHair() {
        try {
            this.crossHair = new Sprite(MyGraphics.getCrossHairPixels(), 0, 16, 13, MyGraphics.getCrossHairMask(), 0, 1);
            this.crossHair.setPosition(43, 33);
            this.crossX = 688;
            this.crossY = 528;
            this.crossHair.setVisible(true);
            this.gfxManager.addObject((GraphicObject)this.crossHair);
        }
        catch (Exception exception) {
            System.out.println("Exception: " + exception);
        }
    }

    private void createScoreSprites() {
        try {
            this.numLivesSpr = new Sprite(MyGraphics.getFontPixels(), 0, 8, 8, MyGraphics.getFontMask(), 0, 20);
            this.numLivesSpr.setPosition(3, 1);
            this.numLivesSpr.setVisible(true);
            this.scoreManager.addObject((GraphicObject)this.numLivesSpr);
            this.score0Spr = new Sprite(MyGraphics.getFontPixels(), 0, 8, 8, MyGraphics.getFontMask(), 0, 20);
            this.score1Spr = new Sprite(MyGraphics.getFontPixels(), 0, 8, 8, MyGraphics.getFontMask(), 0, 20);
            this.score2Spr = new Sprite(MyGraphics.getFontPixels(), 0, 8, 8, MyGraphics.getFontMask(), 0, 20);
            this.score3Spr = new Sprite(MyGraphics.getFontPixels(), 0, 8, 8, MyGraphics.getFontMask(), 0, 20);
            this.score0Spr.setPosition(76, 1);
            this.score1Spr.setPosition(82, 1);
            this.score2Spr.setPosition(88, 1);
            this.score3Spr.setPosition(94, 1);
            this.score0Spr.setVisible(true);
            this.score1Spr.setVisible(true);
            this.score2Spr.setVisible(true);
            this.score3Spr.setVisible(true);
            this.scoreManager.addObject((GraphicObject)this.score0Spr);
            this.scoreManager.addObject((GraphicObject)this.score1Spr);
            this.scoreManager.addObject((GraphicObject)this.score2Spr);
            this.scoreManager.addObject((GraphicObject)this.score3Spr);
        }
        catch (Exception exception) {
            System.out.println("Exception: " + exception);
        }
    }

    public GameScreen(RMSData rMSData, MyResource myResource) {
        this.m_ExternData = rMSData;
        this.m_nLastScore = this.m_nScore = 0;
        this.m_nLivesLeft = 5;
        this.m_bGameOver = false;
        if (rMSData.m_nLevel == 0) {
            this.m_nLevel = 0;
        } else if (rMSData.m_nLevel == 1) {
            this.m_nLevel = 4;
        } else if (rMSData.m_nLevel == 2) {
            this.m_nLevel = 7;
        }
        this.m_nTopPixelsY = 0;
        MyGraphics.loadGraphicsForGame(myResource);
        try {
            this.gfxManager = new GraphicObjectManager();
            this.scoreManager = new GraphicObjectManager();
            this.BalloonLayers = new Layer[3];
            this.BalloonLayers[0] = new Layer(0);
            this.BalloonLayers[1] = new Layer(1);
            this.BalloonLayers[2] = new Layer(2);
            this.gameScreenImage = Image.createImage((int)104, (int)80);
            this.gameScreen = new ExtendedImage(this.gameScreenImage);
            this.gameScreen.clear((byte)0);
            this.createCrossHair();
            this.createScoreSprites();
        }
        catch (Exception exception) {
            System.out.println("Exception: " + exception);
        }
        System.gc();
        this.m_bReadyToPaint = true;
    }

    public void Dispose() {
        this.gameScreen = null;
        this.gfxManager = null;
        MyGraphics.freeGraphicsForGame();
    }

    public void paint(Graphics graphics) {
        if (this.gameScreen != null && this.m_bReadyToPaint) {
            this.gameScreen.blitToScreen(0, 0);
        }
    }

    public int getReturnValue() {
        return 0;
    }

    public void updateCrossHair() {
        int n = 20;
        if (this.currentKeyState == 0) {
            n = 0;
        } else if (this.currentKeyState == 2) {
            n = 40;
        }
        switch (this.currentKey) {
            case 1: 
            case 50: {
                this.crossY -= n;
                break;
            }
            case 6: 
            case 56: {
                this.crossY += n;
                break;
            }
            case 5: 
            case 54: {
                this.crossX += n;
                break;
            }
            case 2: 
            case 52: {
                this.crossX -= n;
                break;
            }
            case 55: {
                this.crossX -= n;
                this.crossY += n;
                break;
            }
            case 57: {
                this.crossX += n;
                this.crossY += n;
                break;
            }
            case 49: {
                this.crossX -= n;
                this.crossY -= n;
                break;
            }
            case 51: {
                this.crossX += n;
                this.crossY -= n;
            }
        }
        if (this.crossX >> 4 < -6) {
            this.crossX = 1504;
        } else if (this.crossX >> 4 > 94) {
            this.crossX = -96;
        }
        if (this.crossY >> 4 < 4) {
            this.crossY = 1168;
        } else if (this.crossY >> 4 > 73) {
            this.crossY = 64;
        }
        this.crossHair.setPosition(this.crossX >> 4, this.crossY >> 4);
        if (this.currentKeyState == 1 && (this.currentKey == 53 || this.currentKey == 8)) {
            this.playSound();
            int n2 = 0;
            boolean bl = false;
            int n3 = this.BalloonLayers[0].FireAt(this.crossX >> 4, this.crossY >> 4);
            if (n3 < 0) {
                bl = true;
                this.m_nScore -= n3;
                n2 -= n3;
            } else {
                this.m_nScore += n3;
                n2 += n3;
            }
            n3 = this.BalloonLayers[1].FireAt(this.crossX >> 4, this.crossY >> 4);
            if (n3 < 0) {
                bl = true;
                this.m_nScore -= n3;
                n2 -= n3;
            } else {
                this.m_nScore += n3;
                n2 += n3;
            }
            n3 = this.BalloonLayers[2].FireAt(this.crossX >> 4, this.crossY >> 4);
            if (n3 < 0) {
                bl = true;
                this.m_nScore -= n3;
                n2 -= n3;
            } else {
                this.m_nScore += n3;
                n2 += n3;
            }
            if (n2 == 0) {
                // empty if block
            }
            if (bl) {
                this.BalloonLayers[0].ExplodeAll();
                this.BalloonLayers[1].ExplodeAll();
                this.BalloonLayers[2].ExplodeAll();
                Vibrator.triggerVibrator((int)100);
            }
        }
    }

    public void AddBalloons(int n) {
        while (n < LevelInfoBalloons[this.m_nLevel]) {
            int n2;
            int n3 = 0;
            boolean bl = false;
            if (this.BalloonLayers[n3].GetNumberBalloons() < 3) {
                bl = true;
            } else if (this.BalloonLayers[++n3].GetNumberBalloons() < 3 && LevelInfoLayers[this.m_nLevel] > 1) {
                bl = true;
            } else if (this.BalloonLayers[++n3].GetNumberBalloons() < 3 && LevelInfoLayers[this.m_nLevel] > 2) {
                bl = true;
            }
            if (!bl) {
                return;
            }
            int n4 = Math.abs(BalloonShooter.rand.nextInt() % 92);
            int n5 = Math.abs(BalloonShooter.rand.nextInt() & 7) + 80;
            int n6 = Math.abs(BalloonShooter.rand.nextInt() & 3);
            int n7 = 0;
            if ((BalloonShooter.rand.nextInt() & 7) == 1) {
                n7 = (BalloonShooter.rand.nextInt() & 1) + 1;
            }
            if ((n2 = yVels[n3]) < LevelInfoTime[this.m_nLevel]) {
                n2 = LevelInfoTime[this.m_nLevel];
            }
            this.BalloonLayers[n3].AddBalloon(n4, n5, n6, n7, n2);
            ++n;
        }
    }

    public void UpdateScore() {
        this.numLivesSpr.setFrame(this.m_nLivesLeft);
        if (this.m_nScore != this.m_nLastScore) {
            int n = this.m_nScore;
            this.score3Spr.setFrame(n % 10);
            this.score2Spr.setFrame((n /= 10) % 10);
            this.score1Spr.setFrame((n /= 10) % 10);
            this.score0Spr.setFrame((n /= 10) % 10);
            this.m_nLastScore = this.m_nScore;
        }
    }

    public void run() {
        this.m_bRunning = true;
        this.m_nFrameCounter = 0;
        this.m_nOldTime = 0;
        while (this.m_bRunning) {
            try {
                Thread.yield();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++this.m_nFrameCounter;
            int n = this.BalloonLayers[0].Update(this.m_nOldTime);
            n += this.BalloonLayers[1].Update(this.m_nOldTime);
            n += this.BalloonLayers[2].Update(this.m_nOldTime);
            if (!this.m_bGameOver) {
                int n2 = this.BalloonLayers[0].m_nLifeToLoose;
                n2 += this.BalloonLayers[1].m_nLifeToLoose;
                if ((n2 += this.BalloonLayers[2].m_nLifeToLoose) != 0) {
                    this.m_nLivesLeft -= n2;
                    if (this.m_nLivesLeft <= 0) {
                        this.m_nLivesLeft = 0;
                        this.m_bGameOver = true;
                        this.crossHair.setVisible(false);
                    }
                }
            }
            this.AddBalloons(n);
            if (!this.m_bGameOver) {
                this.updateCrossHair();
            }
            this.m_nOldTime += 50;
            if (this.m_nScore >= LevelInfoScore[this.m_nLevel]) {
                ++this.m_nLevel;
                if (this.m_nLevel > 13) {
                    this.m_nLevel = 13;
                }
            }
            this.UpdateScore();
            try {
                this.gameScreen.clear((byte)0);
                this.BalloonLayers[2].Paint(this.gameScreen);
                this.BalloonLayers[1].Paint(this.gameScreen);
                this.BalloonLayers[0].Paint(this.gameScreen);
                this.gfxManager.paint(this.gameScreen, 0, 0);
                if (this.m_bGameOver && this.m_nTopPixelsY > -10 && (this.m_nFrameCounter & 1) == 0) {
                    --this.m_nTopPixelsY;
                }
                this.gameScreen.setPixels(MyGraphics.getTopPixels(), 0, this.m_nTopPixelsY, 104, 10);
                this.scoreManager.paint(this.gameScreen, 0, this.m_nTopPixelsY);
                if (this.m_bGameOver) {
                    String string = this.m_nScore + " " + Local.getStr(18);
                    Font font = this.gameScreen.getImage().getGraphics().getFont();
                    int n3 = font.stringWidth(string);
                    int n4 = 101 - n3 >> 1;
                    this.gameScreen.getImage().getGraphics().setColor(0xFFFFFF);
                    this.gameScreen.getImage().getGraphics().fillRect(n4 - 3, 31, n3 + 7, 13);
                    this.gameScreen.getImage().getGraphics().setColor(0);
                    this.gameScreen.getImage().getGraphics().drawRect(n4 - 4, 30, n3 + 8, 14);
                    this.gameScreen.getImage().getGraphics().drawString(string, n4, 32, 20);
                }
                this.gameScreen.blitToScreen(0, 0);
                if (this.currentKey == -12) {
                    this.m_bRunning = false;
                }
                if (!this.m_bGameOver || this.currentKey != 8) continue;
                this.m_bRunning = false;
            }
            catch (Exception exception) {
                System.out.println("Exception: " + exception);
            }
        }
        if (this.m_nScore > this.m_ExternData.m_nHighscore) {
            this.m_ExternData.m_nHighscore = this.m_nScore;
            this.m_ExternData.m_bNewRecord = true;
        }
    }
}

