/*
 * Decompiled with CFR 0.152.
 */
package tictactoe;

import com.siemens.mp.game.Vibrator;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import tictactoe.Backable;
import tictactoe.CircleDraw;
import tictactoe.CrossDraw;
import tictactoe.PlayerLost;
import tictactoe.PlayerWon;
import tictactoe.StaleMate;

class TicCanvas
extends Canvas
implements CommandListener,
Backable {
    Display display;
    int width;
    int height;
    private static final Command ok = new Command("Ok", 4, 1);
    int white;
    int black;
    static final int[] moves = new int[]{4, 0, 2, 6, 8, 1, 3, 5, 7};
    static boolean[] won = new boolean[512];
    static final int DONE = 511;
    static final int OK = 0;
    static final int WIN = 1;
    static final int LOSE = 2;
    static final int STALEMATE = 3;
    boolean first = true;

    public TicCanvas(Display display) {
        this.display = display;
        this.width = this.getWidth();
        this.height = this.getHeight();
    }

    public void shows() {
        this.display.setCurrent((Displayable)this);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == ok) {
            this.shows();
        }
    }

    public void paint(Graphics graphics) {
        graphics.setColor(0xFFFFFF);
        graphics.fillRect(0, 0, this.width - 1, this.height - 1);
        graphics.setColor(0);
        int n = this.width / 3;
        int n2 = this.height / 3;
        int n3 = 4;
        graphics.drawLine(n, 0, n, this.height);
        graphics.drawLine(2 * n, 0, 2 * n, this.height);
        graphics.drawLine(0, n2, this.width, n2);
        graphics.drawLine(0, 2 * n2, this.width, 2 * n2);
        int n4 = 0;
        int n5 = 0;
        while (n5 < 3) {
            int n6 = 0;
            while (n6 < 3) {
                if ((this.white & 1 << n4) != 0) {
                    CircleDraw circleDraw = new CircleDraw(n, n2, n6, n5, n3);
                    circleDraw.paint(graphics);
                } else if ((this.black & 1 << n4) != 0) {
                    CrossDraw crossDraw = new CrossDraw(n, n2, n6, n5, n3);
                    crossDraw.paint(graphics);
                }
                ++n6;
                ++n4;
            }
            ++n5;
        }
    }

    public void keyPressed(int n) {
        int n2 = 0;
        switch (n) {
            case 49: {
                n2 = 0;
                break;
            }
            case 50: {
                n2 = 1;
                break;
            }
            case 51: {
                n2 = 2;
                break;
            }
            case 52: {
                n2 = 3;
                break;
            }
            case 53: {
                n2 = 4;
                break;
            }
            case 54: {
                n2 = 5;
                break;
            }
            case 55: {
                n2 = 6;
                break;
            }
            case 56: {
                n2 = 7;
                break;
            }
            case 57: {
                n2 = 8;
            }
        }
        switch (this.status()) {
            case 1: 
            case 2: 
            case 3: {
                this.black = 0;
                this.white = 0;
                if (this.first) {
                    this.white |= 0x10;
                }
                this.first = !this.first;
                this.repaint();
                return;
            }
        }
        if (this.yourMove(n2)) {
            this.repaint();
            block14 : switch (this.status()) {
                case 1: {
                    PlayerLost playerLost = new PlayerLost();
                    playerLost.shows(this.display, this);
                    break;
                }
                case 2: {
                    PlayerWon playerWon = new PlayerWon();
                    playerWon.shows(this.display, this);
                    Vibrator.triggerVibrator((int)2000);
                    break;
                }
                case 3: {
                    StaleMate staleMate = new StaleMate();
                    staleMate.shows(this.display, this);
                    break;
                }
                default: {
                    if (!this.myMove()) break;
                    this.repaint();
                    switch (this.status()) {
                        case 1: {
                            PlayerLost playerLost = new PlayerLost();
                            playerLost.shows(this.display, this);
                            break block14;
                        }
                        case 2: {
                            PlayerWon playerWon = new PlayerWon();
                            playerWon.shows(this.display, this);
                            Vibrator.triggerVibrator((int)2000);
                            break block14;
                        }
                        case 3: {
                            StaleMate staleMate = new StaleMate();
                            staleMate.shows(this.display, this);
                            break block14;
                        }
                    }
                }
            }
        }
    }

    static void isWon(int n) {
        int n2 = 0;
        while (n2 < 511) {
            if ((n2 & n) == n) {
                TicCanvas.won[n2] = true;
            }
            ++n2;
        }
    }

    int bestMove(int n, int n2) {
        int n3;
        int n4;
        int n5 = -1;
        int n6 = 0;
        while (n6 < 9) {
            block9: {
                n4 = moves[n6];
                if ((n & 1 << n4) == 0 && (n2 & 1 << n4) == 0) {
                    n3 = n | 1 << n4;
                    if (won[n3]) {
                        return n4;
                    }
                    int n7 = 0;
                    while (n7 < 9) {
                        int n8;
                        if ((n3 & 1 << n7) != 0 || (n2 & 1 << n7) != 0 || !won[n8 = n2 | 1 << n7]) {
                            ++n7;
                            continue;
                        }
                        break block9;
                    }
                    if (n5 == -1) {
                        n5 = n4;
                    }
                }
            }
            ++n6;
        }
        if (n5 != -1) {
            return n5;
        }
        n4 = 0;
        while (n4 < 9) {
            n3 = moves[n4];
            if ((n & 1 << n3) == 0 && (n2 & 1 << n3) == 0) {
                return n3;
            }
            ++n4;
        }
        return -1;
    }

    boolean yourMove(int n) {
        if (n < 0 || n > 8) {
            return false;
        }
        if (((this.black | this.white) & 1 << n) != 0) {
            return false;
        }
        this.black |= 1 << n;
        return true;
    }

    boolean myMove() {
        if ((this.black | this.white) == 511) {
            return false;
        }
        int n = this.bestMove(this.white, this.black);
        this.white |= 1 << n;
        return true;
    }

    int status() {
        if (won[this.white]) {
            return 1;
        }
        if (won[this.black]) {
            return 2;
        }
        if ((this.black | this.white) == 511) {
            return 3;
        }
        return 0;
    }

    static {
        TicCanvas.isWon(7);
        TicCanvas.isWon(56);
        TicCanvas.isWon(448);
        TicCanvas.isWon(73);
        TicCanvas.isWon(146);
        TicCanvas.isWon(292);
        TicCanvas.isWon(273);
        TicCanvas.isWon(84);
    }
}

