/*
 * Decompiled with CFR 0.152.
 */
package GameAPI_Demo;

import GameAPI_Demo.GameAPI_Demo;
import GameAPI_Demo.MyScreen;
import com.siemens.mp.game.ExtendedImage;
import com.siemens.mp.game.GraphicObject;
import com.siemens.mp.game.GraphicObjectManager;
import com.siemens.mp.game.Sprite;
import com.siemens.mp.game.TiledBackground;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

class TiledScreen
extends MyScreen {
    private static final int GRAVITY = 4096;
    public boolean running;
    private boolean readyToPaint = false;
    private static final int GAME_SCREEN_WIDTH = 96;
    private static final int GAME_SCREEN_HEIGHT = 80;
    private Image gameScreenImage;
    private ExtendedImage gameScreen = null;
    private GraphicObjectManager gfxManager;
    private TiledBackground tiledBack;
    private TiledBackground tiled2Back;
    private byte[] birdPixels;
    private byte[] ballPixels;
    private byte[] birdMask;
    private byte[] ballMask;
    private Sprite birdSpr;
    private Sprite ballSpr;
    private int ballX;
    private int ballY;
    private int ballXVel;
    private int ballYVel;
    private int ballDelay;
    private int ballFrame = 0;
    private int birdX;
    private int birdY;
    private int birdXVel;
    private int birdYVel;
    private int birdDelay;
    private int birdFrame = 0;
    private int nFrameCounter;
    private boolean bFirePressed;
    private byte[] tiledPixels;
    private byte[] tiled2Pixels;
    private byte[] tiled2Mask;
    private int mapX = 0;
    private int mapY = 0;
    private int speedX = 32768;
    private int speedY = 32768;
    private int map2X = 0x200000;
    private int map2Y = 0;
    private int speed2X = Short.MIN_VALUE;
    private int speed2Y = 32768;
    private byte[] map = new byte[]{3, 4, 5, 6, 3, 4, 5, 6, 3, 4, 5, 6, 3, 4, 5, 6, 3, 4, 5, 6, 3, 4, 5, 6, 7, 8, 9, 10, 7, 8, 9, 10, 7, 8, 9, 10, 7, 8, 9, 10, 7, 8, 9, 10, 7, 8, 9, 10, 11, 12, 13, 14, 11, 12, 13, 14, 11, 12, 13, 14, 11, 12, 13, 14, 11, 12, 13, 14, 11, 12, 13, 14, 15, 16, 17, 18, 15, 16, 17, 18, 15, 16, 17, 18, 15, 16, 17, 18, 15, 16, 17, 18, 15, 16, 17, 18, 3, 4, 5, 6, 3, 4, 5, 6, 3, 4, 5, 6, 3, 4, 5, 6, 3, 4, 5, 6, 3, 4, 5, 6, 7, 8, 9, 10, 7, 8, 9, 10, 7, 8, 9, 10, 7, 8, 9, 10, 7, 8, 9, 10, 7, 8, 9, 10, 11, 12, 13, 14, 11, 12, 13, 14, 11, 12, 13, 14, 11, 12, 13, 14, 11, 12, 13, 14, 11, 12, 13, 14, 15, 16, 17, 18, 15, 16, 17, 18, 15, 16, 17, 18, 15, 16, 17, 18, 15, 16, 17, 18, 15, 16, 17, 18, 3, 4, 5, 6, 3, 4, 5, 6, 3, 4, 5, 6, 3, 4, 5, 6, 3, 4, 5, 6, 3, 4, 5, 6, 7, 8, 9, 10, 7, 8, 9, 10, 7, 8, 9, 10, 7, 8, 9, 10, 7, 8, 9, 10, 7, 8, 9, 10, 11, 12, 13, 14, 11, 12, 13, 14, 11, 12, 13, 14, 11, 12, 13, 14, 11, 12, 13, 14, 11, 12, 13, 14, 15, 16, 17, 18, 15, 16, 17, 18, 15, 16, 17, 18, 15, 16, 17, 18, 15, 16, 17, 18, 15, 16, 17, 18, 3, 4, 5, 6, 3, 4, 5, 6, 3, 4, 5, 6, 3, 4, 5, 6, 3, 4, 5, 6, 3, 4, 5, 6, 7, 8, 9, 10, 7, 8, 9, 10, 7, 8, 9, 10, 7, 8, 9, 10, 7, 8, 9, 10, 7, 8, 9, 10, 11, 12, 13, 14, 11, 12, 13, 14, 11, 12, 13, 14, 11, 12, 13, 14, 11, 12, 13, 14, 11, 12, 13, 14, 15, 16, 17, 18, 15, 16, 17, 18, 15, 16, 17, 18, 15, 16, 17, 18, 15, 16, 17, 18, 15, 16, 17, 18, 3, 4, 5, 6, 3, 4, 5, 6, 3, 4, 5, 6, 3, 4, 5, 6, 3, 4, 5, 6, 3, 4, 5, 6, 7, 8, 9, 10, 7, 8, 9, 10, 7, 8, 9, 10, 7, 8, 9, 10, 7, 8, 9, 10, 7, 8, 9, 10, 11, 12, 13, 14, 11, 12, 13, 14, 11, 12, 13, 14, 11, 12, 13, 14, 11, 12, 13, 14, 11, 12, 13, 14, 15, 16, 17, 18, 15, 16, 17, 18, 15, 16, 17, 18, 15, 16, 17, 18, 15, 16, 17, 18, 15, 16, 17, 18, 3, 4, 5, 6, 3, 4, 5, 6, 3, 4, 5, 6, 3, 4, 5, 6, 3, 4, 5, 6, 3, 4, 5, 6, 7, 8, 9, 10, 7, 8, 9, 10, 7, 8, 9, 10, 7, 8, 9, 10, 7, 8, 9, 10, 7, 8, 9, 10, 11, 12, 13, 14, 11, 12, 13, 14, 11, 12, 13, 14, 11, 12, 13, 14, 11, 12, 13, 14, 11, 12, 13, 14, 15, 16, 17, 18, 15, 16, 17, 18, 15, 16, 17, 18, 15, 16, 17, 18, 15, 16, 17, 18, 15, 16, 17, 18};
    private static final int mapXSize = 24;
    private static final int mapYSize = 24;
    private byte[] map2 = new byte[]{4, 5, 6, 7, 8, 3, 4, 5, 6, 7, 8, 3, 4, 5, 6, 7, 8, 3, 9, 10, 11, 12, 13, 14, 9, 10, 11, 12, 13, 14, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 15, 16, 17, 18, 19, 20, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 21, 22, 23, 24, 25, 26, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 27, 28, 29, 30, 31, 32, 27, 28, 29, 30, 31, 32, 3, 33, 34, 35, 36, 3, 3, 33, 34, 35, 36, 3, 3, 33, 34, 35, 36, 3, 4, 5, 6, 7, 8, 3, 4, 5, 6, 7, 8, 3, 4, 5, 6, 7, 8, 3, 9, 10, 11, 12, 13, 14, 9, 10, 11, 12, 13, 14, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 15, 16, 17, 18, 19, 20, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 21, 22, 23, 24, 25, 26, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 27, 28, 29, 30, 31, 32, 27, 28, 29, 30, 31, 32, 3, 33, 34, 35, 36, 3, 3, 33, 34, 35, 36, 3, 3, 33, 34, 35, 36, 3, 4, 5, 6, 7, 8, 3, 4, 5, 6, 7, 8, 3, 4, 5, 6, 7, 8, 3, 9, 10, 11, 12, 13, 14, 9, 10, 11, 12, 13, 14, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 15, 16, 17, 18, 19, 20, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 21, 22, 23, 24, 25, 26, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 27, 28, 29, 30, 31, 32, 27, 28, 29, 30, 31, 32, 3, 33, 34, 35, 36, 3, 3, 33, 34, 35, 36, 3, 3, 33, 34, 35, 36, 3};
    private static final int map2XSize = 18;
    private static final int map2YSize = 18;

    public TiledScreen() {
        try {
            this.gameScreenImage = Image.createImage((int)96, (int)80);
            this.gameScreen = new ExtendedImage(this.gameScreenImage);
            this.gameScreen.clear((byte)0);
        }
        catch (Exception exception) {
            System.out.println("Exception: " + exception);
        }
        this.gfxManager = new GraphicObjectManager();
        try {
            this.birdPixels = this.ReadByteArray("res\\bird.bin", 480, 0);
            this.birdMask = this.ReadByteArray("res\\bird.mask", 480, 0);
            this.ballPixels = this.ReadByteArray("res\\ball.bin", 640, 0);
            this.ballMask = this.ReadByteArray("res\\ball.mask", 640, 0);
            this.tiledPixels = this.ReadByteArray("res\\tiles.bin", 128, 0);
            this.tiledBack = new TiledBackground(this.tiledPixels, null, this.map, 24, 24);
            this.gfxManager.addObject((GraphicObject)this.tiledBack);
            this.birdSpr = new Sprite(this.birdPixels, 0, 32, 24, this.birdMask, 0, 5);
            this.birdX = 0x200000;
            this.birdY = -2097152;
            this.birdSpr.setPosition(this.birdX >> 16, this.birdY >> 16);
            this.birdSpr.setVisible(true);
            this.birdYVel = 16384;
            this.birdXVel = 4096;
            if ((Math.abs(GameAPI_Demo.rand.nextInt()) & 1) == 1) {
                this.birdXVel = -this.birdXVel;
            }
            this.birdDelay = 0;
            this.ballSpr = new Sprite(this.ballPixels, 0, 32, 32, this.ballMask, 0, 5);
            this.ballX = 0x2A0000;
            this.ballY = 0x140000;
            this.ballYVel = 0;
            this.ballXVel = 32768;
            this.ballDelay = 0;
            this.ballSpr.setPosition(this.ballX >> 16, this.ballY >> 16);
            this.ballSpr.setVisible(true);
            this.gfxManager.addObject((GraphicObject)this.ballSpr);
            this.tiled2Pixels = this.ReadByteArray("res\\tiles2.bin", 280, 0);
            this.tiled2Mask = this.ReadByteArray("res\\tiles2.mask", 280, 0);
            this.tiled2Back = new TiledBackground(this.tiled2Pixels, this.tiled2Mask, this.map2, 18, 18);
            this.gfxManager.addObject((GraphicObject)this.tiled2Back);
            this.gfxManager.addObject((GraphicObject)this.birdSpr);
        }
        catch (Exception exception) {
            System.out.println("Exception: " + exception);
        }
        System.gc();
        this.readyToPaint = true;
    }

    public void Dispose() {
        this.gameScreen = null;
        this.gfxManager = null;
    }

    private void updateSprite() {
        this.mapX += this.speedX;
        if (this.mapX > 0x60FFFF) {
            this.mapX = 0x60FFFF;
            this.speedX = -this.speedX;
        } else if (this.mapX < 0) {
            this.mapX = 0;
            this.speedX = -this.speedX;
        }
        this.mapY += this.speedY;
        if (this.mapY > 0x70FFFF) {
            this.mapY = 0x70FFFF;
            this.speedY = -this.speedY;
        } else if (this.mapY < 0) {
            this.mapY = 0;
            this.speedY = -this.speedY;
        }
        this.map2X += this.speed2X;
        if (this.map2X > 0x30FFFF) {
            this.map2X = 0x30FFFF;
            this.speed2X = -this.speed2X;
        } else if (this.map2X < 0) {
            this.map2X = 0;
            this.speed2X = -this.speed2X;
        }
        this.map2Y += this.speed2Y;
        if (this.map2Y > 0x40FFFF) {
            this.map2Y = 0x40FFFF;
            this.speed2Y = -this.speed2Y;
        } else if (this.map2Y < 0) {
            this.map2Y = 0;
            this.speed2Y = -this.speed2Y;
        }
        this.tiledBack.setPositionInMap(this.mapX >> 16, this.mapY >> 16);
        this.tiled2Back.setPositionInMap(this.map2X >> 16, this.map2Y >> 16);
        this.ballYVel += 4096;
        this.ballX += this.ballXVel;
        if (this.ballX < -196608 || this.ballX > 0x430000) {
            this.ballX -= this.ballXVel;
            this.ballXVel = -this.ballXVel;
        }
        this.ballY += this.ballYVel;
        if (this.ballY > 0x380000) {
            this.ballY -= this.ballYVel;
            this.ballYVel = -this.ballYVel;
        }
        if (this.ballDelay == 0) {
            this.ballDelay = 5;
            this.ballFrame = this.ballXVel > 0 ? --this.ballFrame : ++this.ballFrame;
            if (this.ballFrame < 0) {
                this.ballFrame = 4;
            } else if (this.ballFrame == 5) {
                this.ballFrame = 0;
            }
            this.ballSpr.setFrame(this.ballFrame);
        } else {
            --this.ballDelay;
        }
        this.ballSpr.setPosition(this.ballX >> 16, this.ballY >> 16);
        this.birdX += this.birdXVel;
        this.birdY += this.birdYVel;
        if (this.birdY > 0x500000) {
            this.birdY = -2097152;
            this.birdXVel = -this.birdXVel;
        }
        this.birdSpr.setPosition(this.birdX >> 16, this.birdY >> 16);
        if (this.birdDelay == 0) {
            this.birdDelay = 5;
            ++this.birdFrame;
            if (this.birdFrame == 5) {
                this.birdFrame = 0;
            }
            this.birdSpr.setFrame(this.birdFrame);
        } else {
            --this.birdDelay;
        }
    }

    public void paint(Graphics graphics) {
        if (this.gameScreen != null && this.readyToPaint) {
            this.gameScreen.clear((byte)0);
            try {
                this.gfxManager.paint(this.gameScreen, 0, 0);
                this.gameScreen.blitToScreen(0, 0);
            }
            catch (Exception exception) {
                System.out.println("Exception: " + exception);
            }
        }
    }

    public int getReturnValue() {
        return 0;
    }

    protected void keyPressed(int n) {
        int n2 = this.getGameAction(n);
        switch (n2) {
            case 8: {
                this.bFirePressed = true;
            }
        }
    }

    public void run() {
        this.running = true;
        this.nFrameCounter = 0;
        while (this.running) {
            try {
                Thread.yield();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++this.nFrameCounter;
            this.updateSprite();
            this.gameScreen.clear((byte)0);
            try {
                this.gfxManager.paint(this.gameScreen, 0, 0);
                this.gameScreen.blitToScreen(0, 0);
            }
            catch (Exception exception) {
                System.out.println("Exception: " + exception);
            }
            if (!this.bFirePressed) continue;
            this.running = false;
        }
    }
}

