/*
 * Decompiled with CFR 0.152.
 */
package GameAPI_Demo;

import GameAPI_Demo.GameAPI_Demo;
import GameAPI_Demo.MyScreen;
import com.siemens.mp.game.ExtendedImage;
import com.siemens.mp.game.GraphicObject;
import com.siemens.mp.game.GraphicObjectManager;
import com.siemens.mp.game.Sprite;
import com.siemens.mp.game.Vibrator;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

class GameScreen
extends MyScreen {
    private static final int HERO_X = 10;
    private static final int[] HERO_FRAMES = new int[]{0, 1, 2, 1, -1};
    private int heroFrameIndex = 0;
    private int heroFrameDelay = 0;
    private static final int MAX_SHOTS = 10;
    private static final int MAX_ALIENS = 3;
    private static final int MAX_EXPLOS = 5;
    public boolean bRunning;
    public boolean gameOver = false;
    private boolean readyToPaint = false;
    private static final int GAME_SCREEN_WIDTH = 96;
    private static final int GAME_SCREEN_HEIGHT = 56;
    private Image gameScreenImage;
    private ExtendedImage gameScreen = null;
    private GraphicObjectManager gfxManager;
    private byte[] background;
    private byte[] heroPixels;
    private byte[] heroMask;
    private byte[] shotPixels;
    private byte[] shotMask;
    private byte[] exploPixels;
    private byte[] exploMask;
    private Sprite heroSpr;
    private Sprite[] shotsSpr;
    private int[] shotsX;
    private int[] shotsY;
    private boolean[] shotsActive;
    private int shotDelay = 0;
    private byte[] aliensPixels;
    private byte[] aliensMask;
    private int[] aliensX;
    private int[] aliensY;
    private int[] aliensFrame;
    private int[] aliensType;
    private int[] aliensFrameDelay;
    private boolean[] aliensActive;
    private Sprite[] aliensSpr;
    private int aliensDelay = 10;
    private static final int ALIENS_ANIM_DELAY = 5;
    private static final int EXPLO_ANIM_DELAY = 3;
    private int[] exploX;
    private int[] exploY;
    private int[] exploFrame;
    private int[] exploFrameDelay;
    private Sprite[] exploSpr;
    private int state;
    private int nFrameCounter;
    private boolean bFirePressed = false;
    private boolean bUpPressed = false;
    private boolean bDownPressed = false;
    private static final int PRESSED = 1;
    private static final int RELEASED = 0;
    private static final int REPEATED = 1;
    private int currentKey;
    private int currentKeyState = 0;
    private int heroY;

    public GameScreen() {
        try {
            this.gfxManager = new GraphicObjectManager();
            this.gameScreenImage = Image.createImage((int)96, (int)56);
            this.gameScreen = new ExtendedImage(this.gameScreenImage);
            this.gameScreen.clear((byte)0);
            this.background = this.ReadByteArray("res\\game.bin", 672, 0);
            this.heroPixels = this.ReadByteArray("res\\sship.bin", 78, 0);
            this.heroMask = this.ReadByteArray("res\\sship.mask", 78, 0);
            this.heroSpr = new Sprite(this.heroPixels, 0, 16, 13, this.heroMask, 0, 3);
            this.heroY = 20;
            this.heroSpr.setPosition(10, this.heroY);
            this.shotPixels = this.ReadByteArray("res\\shot.bin", 3, 0);
            this.shotMask = this.ReadByteArray("res\\shot.mask", 3, 0);
            this.aliensPixels = this.ReadByteArray("res\\aliens.bin", 312, 0);
            this.aliensMask = this.ReadByteArray("res\\aliens.mask", 312, 0);
            this.exploPixels = this.ReadByteArray("res\\explo.bin", 130, 0);
            this.exploMask = this.ReadByteArray("res\\explo.mask", 130, 0);
            this.shotsSpr = new Sprite[10];
            this.shotsX = new int[10];
            this.shotsY = new int[10];
            this.shotsActive = new boolean[10];
            int n = 0;
            while (n < 10) {
                this.shotsSpr[n] = new Sprite(this.shotPixels, 0, 8, 3, this.shotMask, 0, 1);
                this.shotsSpr[n].setVisible(false);
                this.shotsSpr[n].setCollisionRectangle(0, 0, 6, 3);
                this.gfxManager.addObject((GraphicObject)this.shotsSpr[n]);
                ++n;
            }
            this.aliensX = new int[3];
            this.aliensY = new int[3];
            this.aliensFrame = new int[3];
            this.aliensType = new int[3];
            this.aliensActive = new boolean[3];
            this.aliensFrameDelay = new int[3];
            this.aliensSpr = new Sprite[3];
            int n2 = 0;
            while (n2 < 3) {
                this.aliensSpr[n2] = new Sprite(this.aliensPixels, 0, 16, 13, this.aliensMask, 0, 12);
                this.aliensSpr[n2].setVisible(false);
                this.gfxManager.addObject((GraphicObject)this.aliensSpr[n2]);
                this.aliensActive[n2] = false;
                ++n2;
            }
            this.exploX = new int[5];
            this.exploY = new int[5];
            this.exploFrame = new int[5];
            this.exploFrameDelay = new int[5];
            this.exploSpr = new Sprite[5];
            int n3 = 0;
            while (n3 < 5) {
                this.exploSpr[n3] = new Sprite(this.exploPixels, 0, 16, 13, this.exploMask, 0, 5);
                this.exploSpr[n3].setVisible(false);
                this.gfxManager.addObject((GraphicObject)this.exploSpr[n3]);
                ++n3;
            }
            this.gfxManager.addObject((GraphicObject)this.heroSpr);
        }
        catch (Exception exception) {
            System.out.println("Exception: " + exception);
        }
        System.gc();
        this.readyToPaint = true;
    }

    public void Dispose() {
        this.gameScreen = null;
        this.gfxManager = null;
    }

    protected void keyPressed(int n) {
        this.currentKey = n;
        switch (this.getGameAction(n)) {
            case 8: {
                this.currentKey = 8;
                break;
            }
            case 1: {
                this.currentKey = 1;
                break;
            }
            case 6: {
                this.currentKey = 6;
            }
        }
        this.currentKeyState = 1;
        if (this.currentKey == 8) {
            this.bRunning = false;
        }
    }

    protected void keyReleased(int n) {
        this.currentKey = n;
        switch (this.getGameAction(n)) {
            case 8: {
                this.currentKey = 8;
                break;
            }
            case 1: {
                this.currentKey = 1;
                break;
            }
            case 6: {
                this.currentKey = 6;
            }
        }
        this.currentKeyState = 0;
    }

    protected void keyRepeated(int n) {
    }

    private void addShot() {
        int n = 0;
        while (n < 10) {
            if (!this.shotsActive[n]) {
                this.shotDelay = 15;
                this.shotsActive[n] = true;
                this.shotsX[n] = 21;
                this.shotsY[n] = this.heroY + 6;
                this.shotsSpr[n].setVisible(true);
                Vibrator.triggerVibrator((int)100);
                return;
            }
            ++n;
        }
    }

    private void addExplo(int n, int n2) {
        int n3 = 0;
        while (n3 < 5) {
            if (!this.exploSpr[n3].getVisible()) {
                this.exploX[n3] = n;
                this.exploY[n3] = n2;
                this.exploFrame[n3] = 0;
                this.exploFrameDelay[n3] = 3;
                this.exploSpr[n3].setVisible(true);
                this.exploSpr[n3].setFrame(0);
                Vibrator.triggerVibrator((int)250);
                return;
            }
            ++n3;
        }
    }

    private boolean addAlien() {
        int n = 0;
        while (n < 3) {
            if (!this.aliensActive[n]) {
                this.aliensActive[n] = true;
                this.aliensX[n] = 96;
                this.aliensY[n] = Math.abs(GameAPI_Demo.rand.nextInt()) % 43;
                this.aliensType[n] = Math.abs(GameAPI_Demo.rand.nextInt()) % 4;
                this.aliensFrame[n] = 0;
                this.aliensFrameDelay[n] = 5;
                this.aliensSpr[n].setVisible(true);
                this.aliensSpr[n].setFrame(this.aliensType[n] * 3 + this.aliensFrame[n]);
                switch (this.aliensType[n]) {
                    case 0: {
                        this.aliensSpr[n].setCollisionRectangle(3, 2, 12, 8);
                        break;
                    }
                    case 1: {
                        this.aliensSpr[n].setCollisionRectangle(1, 4, 12, 5);
                        break;
                    }
                    case 2: {
                        this.aliensSpr[n].setCollisionRectangle(3, 3, 8, 6);
                        break;
                    }
                    case 3: {
                        this.aliensSpr[n].setCollisionRectangle(3, 3, 11, 5);
                    }
                }
                return true;
            }
            ++n;
        }
        return false;
    }

    private void updateSprite() {
        int n;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (this.currentKeyState != 0) {
            switch (this.currentKey) {
                case 50: {
                    bl2 = true;
                    break;
                }
                case 1: {
                    bl2 = true;
                    break;
                }
                case 56: {
                    bl3 = true;
                    break;
                }
                case 6: {
                    bl3 = true;
                    break;
                }
                case 53: {
                    bl = true;
                }
            }
        }
        if (bl2 && this.heroY > 0) {
            --this.heroY;
        }
        if (bl3 && this.heroY < 43) {
            ++this.heroY;
        }
        if (this.shotDelay != 0) {
            --this.shotDelay;
        }
        if (this.shotDelay == 0 && bl) {
            this.addShot();
        }
        int n2 = 0;
        while (n2 < 10) {
            if (this.shotsActive[n2]) {
                int n3 = n2;
                this.shotsX[n3] = this.shotsX[n3] + 2;
                if (this.shotsX[n2] >= 96) {
                    this.shotsActive[n2] = false;
                    this.shotsSpr[n2].setVisible(false);
                }
                this.shotsSpr[n2].setPosition(this.shotsX[n2], this.shotsY[n2]);
            }
            ++n2;
        }
        if (this.aliensDelay == 0) {
            if (this.addAlien()) {
                this.aliensDelay = 24;
            }
        } else {
            --this.aliensDelay;
        }
        int n4 = 0;
        while (n4 < 3) {
            if (this.aliensActive[n4]) {
                int n5 = n4;
                this.aliensX[n5] = this.aliensX[n5] - 1;
                if (this.aliensX[n4] == -16) {
                    this.aliensActive[n4] = false;
                    this.aliensSpr[n4].setVisible(false);
                } else {
                    this.aliensSpr[n4].setPosition(this.aliensX[n4], this.aliensY[n4]);
                    if (this.aliensFrameDelay[n4] > 0) {
                        int n6 = n4;
                        this.aliensFrameDelay[n6] = this.aliensFrameDelay[n6] - 1;
                    } else {
                        this.aliensFrameDelay[n4] = 5;
                        int n7 = n4;
                        this.aliensFrame[n7] = this.aliensFrame[n7] + 1;
                        if (this.aliensFrame[n4] == 3) {
                            this.aliensFrame[n4] = 0;
                        }
                        this.aliensSpr[n4].setFrame(this.aliensType[n4] * 3 + this.aliensFrame[n4]);
                    }
                }
                if (this.heroSpr.isCollidingWith(this.aliensSpr[n4])) {
                    this.aliensSpr[n4].setVisible(false);
                    this.aliensActive[n4] = false;
                    this.heroSpr.setVisible(false);
                    this.gameOver = true;
                    this.addExplo(10, this.heroY);
                }
            }
            ++n4;
        }
        int n8 = 0;
        while (n8 < 10) {
            if (this.shotsActive[n8]) {
                n = 0;
                while (n < 3) {
                    if (this.aliensActive[n] && this.aliensSpr[n].isCollidingWithPos(this.shotsX[n8] + 5, this.shotsY[n8] + 1)) {
                        this.aliensSpr[n].setVisible(false);
                        this.aliensActive[n] = false;
                        this.shotsSpr[n8].setVisible(false);
                        this.shotsActive[n8] = false;
                        this.addExplo(this.aliensX[n], this.aliensY[n]);
                    }
                    ++n;
                }
            }
            ++n8;
        }
        n = 0;
        while (n < 5) {
            if (this.exploSpr[n].getVisible()) {
                if (this.exploFrameDelay[n] > 0) {
                    int n9 = n;
                    this.exploFrameDelay[n9] = this.exploFrameDelay[n9] - 1;
                } else {
                    this.exploFrameDelay[n] = 3;
                    int n10 = n;
                    this.exploFrame[n10] = this.exploFrame[n10] + 1;
                    if (this.exploFrame[n] == 5) {
                        this.exploSpr[n].setVisible(false);
                    }
                    this.exploSpr[n].setFrame(this.exploFrame[n]);
                }
                this.exploSpr[n].setPosition(this.exploX[n], this.exploY[n]);
            }
            ++n;
        }
        this.heroSpr.setPosition(10, this.heroY);
        if (this.heroFrameDelay == 0) {
            this.heroFrameDelay = 5;
            ++this.heroFrameIndex;
            if (HERO_FRAMES[this.heroFrameIndex] == -1) {
                this.heroFrameIndex = 0;
            }
            this.heroSpr.setFrame(HERO_FRAMES[this.heroFrameIndex]);
        } else {
            --this.heroFrameDelay;
        }
    }

    public void paint(Graphics graphics) {
        if (this.gameScreen != null && this.readyToPaint) {
            this.gameScreen.blitToScreen(0, 0);
        }
    }

    public int getReturnValue() {
        return 0;
    }

    public void run() {
        this.bRunning = true;
        this.nFrameCounter = 0;
        while (this.bRunning) {
            try {
                if (this.gameOver) {
                    this.gameScreen.getImage().getGraphics().drawString("Game Over!", 20, 20, 20);
                    this.gameScreen.blitToScreen(0, 13);
                    Thread.sleep(4000L);
                    this.bRunning = false;
                }
                Thread.yield();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++this.nFrameCounter;
            this.updateSprite();
            try {
                this.gameScreen.setPixels(this.background, 0, 0, 96, 56);
                this.gfxManager.paint(this.gameScreen, 0, 0);
                this.gameScreen.blitToScreen(0, 13);
            }
            catch (Exception exception) {
                System.out.println("Exception: " + exception);
            }
        }
    }
}

