/*
 * Decompiled with CFR 0.152.
 */
import java.util.Calendar;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

class ClockCanvas
extends Canvas {
    private int horizMedian;
    private int vertMedian;
    private int bottomLineYPos;
    private Font smallFont;
    private Font largeFont;
    private boolean init = true;
    private boolean visible = true;

    ClockCanvas() {
    }

    private void initValues() {
        this.smallFont = Font.getFont((int)64, (int)0, (int)8);
        this.largeFont = Font.getFont((int)64, (int)0, (int)16);
        this.horizMedian = this.getWidth() / 2;
        this.vertMedian = this.getHeight() / 2;
        this.bottomLineYPos = this.getHeight() - this.smallFont.getHeight();
    }

    private String getTimeString(Calendar calendar) {
        String string = "";
        int n = calendar.get(10);
        if (n < 10) {
            string = string + "0";
        }
        string = string + Integer.toString(n) + ":";
        n = calendar.get(12);
        if (n < 10) {
            string = string + "0";
        }
        string = string + Integer.toString(n) + ":";
        n = calendar.get(13);
        if (n < 10) {
            string = string + "0";
        }
        string = string + Integer.toString(n);
        return string;
    }

    public void showNotify() {
        this.visible = true;
    }

    public void hideNotify() {
        this.visible = false;
    }

    public void paint(Graphics graphics) {
        if (this.visible) {
            if (this.init) {
                this.initValues();
                this.init = false;
            }
            Calendar calendar = Calendar.getInstance();
            String string = ((Object)calendar).toString();
            graphics.setFont(this.smallFont);
            graphics.drawString(string.substring(0, 16), this.horizMedian, this.bottomLineYPos, 17);
            String string2 = this.getTimeString(calendar);
            graphics.setFont(this.largeFont);
            graphics.drawString(string2, this.horizMedian, this.vertMedian, 17);
        }
        this.repaint();
    }
}

