/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;

public class MicroCache {
    static Vector addressBook = new Vector();
    static Vector inbox = new Vector();
    static Vector outbox = new Vector();
    static Vector sent = new Vector();
    static Vector deleted = new Vector();
    static boolean addressBookValid = false;
    static boolean inboxValid = false;
    static boolean outboxValid = false;
    static boolean sentValid = false;
    static boolean deletedValid = false;

    public static void deleteAddress(Address address, int n) {
        AddressHandler.deleteRecord(address.ID);
        addressBook.removeElementAt(n);
    }

    public static void deleteBox(int n) {
        MessageHandler.deleteBox(n);
        Vector vector = MicroCache.getBoxVector(n);
        vector.removeAllElements();
        System.gc();
    }

    public static void deleteMessage(int n, int n2, Message message) {
        if (n == 4) {
            MessageHandler.deleteRecord(n, message.ID);
            deleted.removeElementAt(n2);
        } else {
            Vector vector = MicroCache.getBoxVector(n);
            MessageHandler.deleteRecord(n, message.ID);
            vector.removeElementAt(n2);
            message.ID = -1;
            MicroCache.storeMessage(4, message, -1);
        }
    }

    public static int getBoxSize(int n) {
        int n2 = 0;
        switch (n) {
            case 1: {
                n2 = inbox.size();
                break;
            }
            case 2: {
                n2 = outbox.size();
                break;
            }
            case 3: {
                n2 = sent.size();
                break;
            }
            case 4: {
                n2 = deleted.size();
            }
        }
        return n2;
    }

    private static Vector getBoxVector(int n) {
        switch (n) {
            case 1: {
                return inbox;
            }
            case 2: {
                return outbox;
            }
            case 3: {
                return sent;
            }
            case 4: {
                return deleted;
            }
        }
        return null;
    }

    public static Message getMessage(int n, int n2) {
        Message message = null;
        MessageHandler.openFile(n);
        message = MessageHandler.getMessage(n2);
        MessageHandler.closeFile();
        return message;
    }

    public static MessageListItem getMessageListItem(int n, int n2) {
        MessageListItem messageListItem = null;
        Vector vector = MicroCache.getBoxVector(n);
        messageListItem = (MessageListItem)vector.elementAt(n2);
        return messageListItem;
    }

    public static void markRead(int n, Message message, int n2, boolean bl) {
        if (bl && message.unread || !bl && !message.unread) {
            message.unread = bl ^ true;
            MicroCache.storeMessage(n, message, n2);
        }
    }

    public static void moveMessageToSent(int n, Message message) {
        MessageHandler.deleteRecord(2, message.ID);
        outbox.removeElementAt(n);
        message.ID = -1;
        MicroCache.storeMessage(3, message, -1);
    }

    public static void refreshAddressBook() {
        if (!addressBookValid) {
            AddressHandler.openFile();
            addressBook = AddressHandler.getAddressBook();
            AddressHandler.closeFile();
            addressBookValid = true;
        }
    }

    public static void refreshMessageList(int n) {
        switch (n) {
            case 1: {
                if (inboxValid) break;
                MessageHandler.openFile(1);
                inbox = MessageHandler.getMessageListByBox(1);
                inboxValid = true;
                MessageHandler.closeFile();
                break;
            }
            case 2: {
                if (outboxValid) break;
                MessageHandler.openFile(2);
                outbox = MessageHandler.getMessageListByBox(2);
                outboxValid = true;
                MessageHandler.closeFile();
                break;
            }
            case 3: {
                if (sentValid) break;
                MessageHandler.openFile(3);
                sent = MessageHandler.getMessageListByBox(3);
                sentValid = true;
                MessageHandler.closeFile();
                break;
            }
            case 4: {
                if (deletedValid) break;
                MessageHandler.openFile(4);
                deleted = MessageHandler.getMessageListByBox(4);
                deletedValid = true;
                MessageHandler.closeFile();
            }
        }
    }

    public static void storeAddress(Address address, int n) {
        AddressHandler.openFile();
        AddressHandler.storeAddress(address);
        AddressHandler.closeFile();
        if (n > -1) {
            addressBook.setElementAt(address, n);
        } else {
            addressBook.addElement(address);
        }
    }

    public static void storeMessage(int n, Message message, int n2) {
        MessageHandler.openFile(n);
        MessageHandler.storeMessage(message, n);
        MessageHandler.closeFile();
        Vector vector = MicroCache.getBoxVector(n);
        MessageListItem messageListItem = new MessageListItem();
        messageListItem.subject = message.subject;
        messageListItem.unread = message.unread;
        if (n2 > -1) {
            vector.setElementAt(messageListItem, n2);
        } else {
            vector.addElement(messageListItem);
        }
        message = null;
        messageListItem = null;
    }
}

