/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.List;

public class MessageList
extends List
implements CommandListener {
    private MicroMail midlet;
    private Displayable parent;
    int activeBoxId;
    private Image imageUnread = null;
    private String imageUnreadName = "/images/EmailUnread.png";
    private String imageReadName = "/images/EmailRead.png";
    private Image imageRead = null;
    Command backCommand = new Command(Resource.getText(1), 2, 4);
    Command downloadCommand = new Command(Resource.getText(9), 1, 1);
    Command sendallCommand = new Command(Resource.getText(10), 1, 1);
    Command newCommand = new Command(Resource.getText(11), 1, 2);
    Command deleteCommand = new Command(Resource.getText(3), 1, 3);
    Command deleteAllCommand = new Command(Resource.getText(51), 1, 4);

    public MessageList(MicroMail microMail, int n) {
        super(String.valueOf(MessageHandler.getBoxName(n)) + "(" + MicroCache.getBoxSize(n) + ")", 3);
        this.midlet = microMail;
        this.activeBoxId = n;
        try {
            this.imageUnread = Image.createImage((String)this.imageUnreadName);
            this.imageRead = Image.createImage((String)this.imageReadName);
        }
        catch (IOException iOException) {}
        this.setCommandListener(this);
        if (n == 1) {
            this.addCommand(this.downloadCommand);
        } else if (n == 2) {
            this.addCommand(this.newCommand);
            this.addCommand(this.sendallCommand);
        }
        this.addCommand(this.backCommand);
        this.addCommand(this.deleteCommand);
        this.addCommand(this.deleteAllCommand);
        int n2 = this.displayMessageList(n);
        System.gc();
    }

    public void appendItem(String string) {
        this.append(string, this.imageUnread);
    }

    public void commandAction(Command command, Displayable displayable) {
        int n;
        MicroMail.mainScreen.setButtonReleased(true);
        if (command == this.backCommand) {
            MicroMail.display.setCurrent((Displayable)MicroMail.mainScreen);
            MicroMail.dispose((Object)this);
        } else if (command == this.downloadCommand) {
            ProgressForm progressForm = new ProgressForm(this.midlet, true);
            MicroMail.display.setCurrent((Displayable)progressForm);
            MicroMail.dispose((Object)this);
        } else if (command == this.sendallCommand) {
            ProgressForm progressForm = new ProgressForm(this.midlet, false);
            MicroMail.display.setCurrent((Displayable)progressForm);
            MicroMail.dispose((Object)this);
        } else if (command == this.newCommand) {
            MessageForm messageForm = new MessageForm(this.midlet, (Displayable)this, null, -1);
            MicroMail.display.setCurrent((Displayable)messageForm);
        } else if (command == this.deleteCommand) {
            int n2 = this.getSelectedIndex();
            if (n2 > -1) {
                Message message = MicroCache.getMessage(this.activeBoxId, n2);
                MicroCache.deleteMessage(this.activeBoxId, n2, message);
                this.deleteItem(n2);
                message = null;
            }
        } else if (command == this.deleteAllCommand) {
            MicroCache.deleteBox(this.activeBoxId);
            MicroMail.display.setCurrent((Displayable)MicroMail.mainScreen);
            MicroMail.dispose((Object)this);
        } else if (command.equals(List.SELECT_COMMAND) && (n = this.getSelectedIndex()) > -1) {
            MessageDetails messageDetails = new MessageDetails(this.midlet, this, this.activeBoxId, n);
            MicroMail.display.setCurrent((Displayable)messageDetails);
        }
    }

    public void deleteItem(int n) {
        this.delete(n);
        this.setTitle(String.valueOf(MessageHandler.getBoxName(this.activeBoxId)) + "(" + MicroCache.getBoxSize(this.activeBoxId) + ")");
    }

    public int displayMessageList(int n) {
        int n2 = 0;
        int n3 = MicroCache.getBoxSize(n);
        MicroCache.refreshMessageList(n);
        if (MicroCache.getBoxSize(n) > 0) {
            int n4 = 0;
            while (n4 < n3) {
                MessageListItem messageListItem = MicroCache.getMessageListItem(n, n4);
                if (messageListItem.unread) {
                    this.append(messageListItem.subject, this.imageUnread);
                } else {
                    this.append(messageListItem.subject, this.imageRead);
                }
                ++n4;
            }
        }
        return n2;
    }

    public void updateItem(int n, String string, boolean bl) {
        if (bl) {
            this.set(n, string, this.imageRead);
        } else {
            this.set(n, string, this.imageUnread);
        }
    }
}

