/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

class MainScreen
extends Canvas
implements CommandListener {
    boolean pressed;
    boolean buttonReleased;
    boolean showIntroScreen = true;
    Font fSmall = Font.getFont((int)32, (int)0, (int)8);
    final int maxItems;
    final int maxOnRow;
    final int xSpace;
    final int ySpace;
    final int xStart;
    final int yStart = this.fSmall.getHeight() + 3;
    int iBottomLine;
    Command aboutCommand = new Command(Resource.getText(48), 1, 1);
    Command helpCommand = new Command(Resource.getText(57), 1, 2);
    Command exitCommand = new Command(Resource.getText(0), 2, 3);
    MicroMail midlet;
    Image[] images = new Image[13];
    Image img;
    int imageWidth;
    int imageHeight;
    int prevSelected;
    int selected;

    public MainScreen(MicroMail microMail) {
        this.maxItems = 5;
        this.maxOnRow = 3;
        this.xSpace = 5;
        this.ySpace = 2;
        this.xStart = 2;
        this.midlet = microMail;
        this.prevSelected = 0;
        this.selected = 0;
        this.pressed = false;
        this.buttonReleased = true;
        try {
            this.img = Image.createImage((String)"/images/MicroMail.png");
            this.images[0] = Image.createImage((String)"/images/Inbox.png");
            this.images[1] = Image.createImage((String)"/images/Outbox.png");
            this.images[2] = Image.createImage((String)"/images/Sent.png");
            this.images[3] = Image.createImage((String)"/images/Deleted.png");
            this.images[4] = Image.createImage((String)"/images/Account.png");
            this.images[5] = Image.createImage((String)"/images/AddressBook.png");
            this.images[6] = Image.createImage((String)"/images/Inbox_p.png");
            this.images[7] = Image.createImage((String)"/images/Outbox_p.png");
            this.images[8] = Image.createImage((String)"/images/Sent_p.png");
            this.images[9] = Image.createImage((String)"/images/Deleted_p.png");
            this.images[10] = Image.createImage((String)"/images/Account_p.png");
            this.images[11] = Image.createImage((String)"/images/AddressBook_p.png");
            this.images[12] = Image.createImage((String)"/images/cocoasoft.png");
            this.imageWidth = this.images[0].getWidth();
            this.imageHeight = this.images[0].getHeight();
            this.iBottomLine = this.yStart + 1 + (this.imageHeight + 2) * 2;
        }
        catch (Exception exception) {
            System.out.println("error");
        }
        this.setCommandListener(this);
        this.addCommand(this.aboutCommand);
        this.addCommand(this.helpCommand);
        this.addCommand(this.exitCommand);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.aboutCommand) {
            Alert alert = new Alert("MicroMail", Resource.getText(61), null, null);
            alert.setTimeout(-2);
            MicroMail.display.setCurrent(alert, (Displayable)this);
        } else if (command == this.helpCommand) {
            Alert alert = new Alert("Help", Resource.getText(60), null, null);
            alert.setTimeout(-2);
            MicroMail.display.setCurrent(alert, (Displayable)this);
        } else if (command == this.exitCommand) {
            try {
                this.midlet.destroyApp(false);
                this.midlet.notifyDestroyed();
            }
            catch (Exception exception) {}
        }
    }

    private void drawSelected(Graphics graphics) {
        int n = this.prevSelected / 3;
        int n2 = this.prevSelected % 3;
        int n3 = 1 + (this.imageWidth + 5) * n2;
        int n4 = this.yStart - 1 + (this.imageHeight + 2) * n;
        graphics.setColor(0xFFFFFF);
        graphics.drawRect(n3, n4, this.imageWidth + 1, this.imageHeight + 1);
        n = this.selected / 3;
        n2 = this.selected % 3;
        n3 = 1 + (this.imageWidth + 5) * n2;
        n4 = this.yStart - 1 + (this.imageHeight + 2) * n;
        graphics.setColor(0);
        if (!this.pressed) {
            graphics.drawRect(n3, n4, this.imageWidth + 1, this.imageHeight + 1);
        } else {
            graphics.drawImage(this.images[this.selected + this.images.length / 2], n3 + 1, n4 + 1, 20);
            try {
                Thread.sleep(50L);
            }
            catch (Exception exception) {}
            this.pressed = false;
            graphics.drawImage(this.images[this.selected], n3 + 1, n4 + 1, 20);
            graphics.drawRect(n3, n4, this.imageWidth + 1, this.imageHeight + 1);
        }
    }

    public void keyPressed(int n) {
        System.out.println("keypress");
        if (!this.buttonReleased) {
            return;
        }
        this.prevSelected = this.selected;
        int n2 = this.getGameAction(n);
        switch (n2) {
            case 1: {
                if (this.selected - 3 > -1) {
                    this.selected -= 3;
                }
                this.repaint();
                this.serviceRepaints();
                break;
            }
            case 6: {
                if (this.selected + 3 <= 5) {
                    this.selected += 3;
                }
                this.repaint();
                this.serviceRepaints();
                break;
            }
            case 2: {
                if (this.selected > 0) {
                    --this.selected;
                }
                this.repaint();
                this.serviceRepaints();
                break;
            }
            case 5: {
                if (this.selected + 1 <= 5) {
                    ++this.selected;
                }
                this.repaint();
                this.serviceRepaints();
                break;
            }
            case 8: {
                this.pressed = true;
                this.buttonReleased = false;
                this.repaint();
                this.serviceRepaints();
                if (this.selected < 4) {
                    MicroCache.refreshMessageList(this.selected + 1);
                    MessageList messageList = new MessageList(this.midlet, this.selected + 1);
                    MicroMail.display.setCurrent((Displayable)messageList);
                    break;
                }
                if (this.selected == 4) {
                    AccountList accountList = new AccountList(this.midlet);
                    MicroMail.display.setCurrent((Displayable)accountList);
                    break;
                }
                if (this.selected != 5) break;
                AddressList addressList = new AddressList(this.midlet, (Displayable)this);
                MicroMail.display.setCurrent((Displayable)addressList);
            }
        }
        System.gc();
    }

    public void paint(Graphics graphics) {
        if (this.showIntroScreen) {
            try {
                graphics.drawImage(this.img, 0, 0, 20);
            }
            catch (Exception exception) {}
        } else {
            try {
                graphics.setColor(0xFFFFFF);
                graphics.fillRect(0, 0, 101, 81);
                graphics.setColor(0);
                graphics.setFont(this.fSmall);
                String string = null;
                if (!this.pressed) {
                    if (this.selected < 4) {
                        string = String.valueOf(Resource.getText(32)) + MessageHandler.getBoxName(this.selected + 1);
                    } else if (this.selected == 4) {
                        string = Resource.getText(15);
                    } else if (this.selected == 5) {
                        string = Resource.getText(12);
                    }
                } else {
                    string = Resource.getText(33);
                }
                graphics.drawString(string, 0, 0, 20);
                graphics.drawLine(0, this.yStart - 4, 101, this.yStart - 4);
                graphics.drawImage(this.images[0], 2, this.yStart, 20);
                graphics.drawImage(this.images[1], 2 + this.imageWidth + 5, this.yStart, 20);
                graphics.drawImage(this.images[2], (2 + this.imageWidth + 5) * 2, this.yStart, 20);
                graphics.drawImage(this.images[3], 2, this.yStart + this.imageHeight + 2, 20);
                graphics.drawImage(this.images[4], 2 + this.imageWidth + 5, this.yStart + this.imageHeight + 2, 20);
                graphics.drawImage(this.images[5], (2 + this.imageWidth + 5) * 2, this.yStart + this.imageHeight + 2, 20);
                graphics.drawLine(0, this.iBottomLine, 101, this.iBottomLine);
                graphics.drawImage(this.images[12], 0, this.iBottomLine + 3, 20);
                this.drawSelected(graphics);
            }
            catch (Exception exception) {
                System.out.println(String.valueOf(exception.getClass().getName()) + ": " + exception.getMessage());
            }
        }
    }

    public void setButtonReleased(boolean bl) {
        this.buttonReleased = bl;
    }

    public void setShowIntroScreen(boolean bl) {
        this.showIntroScreen = bl;
        this.repaint();
        this.serviceRepaints();
    }
}

