/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.List;

public class AddressList
extends List
implements CommandListener {
    private MicroMail midlet;
    private Displayable parent;
    private Image image;
    private String imageName = "/images/AddressBook1.png";
    Command backCommand = new Command(Resource.getText(1), 2, 4);
    Command newCommand = new Command(Resource.getText(4), 1, 2);
    Command deleteCommand = new Command(Resource.getText(3), 1, 3);

    public AddressList(MicroMail microMail, Displayable displayable) {
        super(Resource.getText(12), 3);
        this.midlet = microMail;
        this.parent = displayable;
        this.setCommandListener(this);
        this.addCommand(this.backCommand);
        if (!(this.parent instanceof MessageForm)) {
            this.addCommand(this.newCommand);
            this.addCommand(this.deleteCommand);
        }
        this.image = null;
        try {
            this.image = Image.createImage((String)this.imageName);
        }
        catch (IOException iOException) {}
        this.displayAddressBook();
    }

    public void appendItem(String string) {
        this.append(string, this.image);
    }

    public void commandAction(Command command, Displayable displayable) {
        MicroMail.mainScreen.setButtonReleased(true);
        if (command == this.backCommand) {
            MicroMail.display.setCurrent(this.parent);
            MicroMail.dispose((Object)this);
        } else if (command == this.newCommand) {
            AddressForm addressForm = new AddressForm(this.midlet, this, -1);
            MicroMail.display.setCurrent((Displayable)addressForm);
        } else if (command == this.deleteCommand) {
            int n = this.getSelectedIndex();
            if (n > -1) {
                Address address = (Address)MicroCache.addressBook.elementAt(this.getSelectedIndex());
                MicroCache.deleteAddress(address, n);
                this.deleteItem(n);
                address = null;
            }
        } else if (command.equals(List.SELECT_COMMAND)) {
            if (this.parent instanceof MessageForm) {
                MessageForm messageForm = (MessageForm)this.parent;
                Address address = null;
                if (MicroCache.addressBook.size() > 0) {
                    address = (Address)MicroCache.addressBook.elementAt(this.getSelectedIndex());
                    messageForm.addAddress(address.email);
                }
                MicroMail.display.setCurrent(this.parent);
                MicroMail.dispose((Object)this);
            } else {
                AddressForm addressForm = new AddressForm(this.midlet, this, this.getSelectedIndex());
                MicroMail.display.setCurrent((Displayable)addressForm);
            }
        }
    }

    public void deleteItem(int n) {
        this.delete(n);
    }

    public void displayAddressBook() {
        MicroCache.refreshAddressBook();
        Address address = new Address();
        if (MicroCache.addressBook.size() > 0) {
            int n = 0;
            while (n < MicroCache.addressBook.size()) {
                address = (Address)MicroCache.addressBook.elementAt(n);
                this.append(address.name, this.image);
                ++n;
            }
        }
    }

    public void updateItem(int n, String string) {
        this.set(n, string, this.image);
    }
}

