/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.TextField;

public class AddressForm
extends Form
implements CommandListener {
    private MicroMail midlet;
    private AddressList parent;
    private Address address;
    private int addressId;
    TextField name;
    TextField email;
    Command backCommand = new Command(Resource.getText(1), 2, 3);
    Command saveCommand = new Command(Resource.getText(2), 1, 1);
    Command deleteCommand = new Command(Resource.getText(3), 1, 2);

    public AddressForm(MicroMail microMail, AddressList addressList, int n) {
        super(Resource.getText(16));
        this.midlet = microMail;
        this.parent = addressList;
        this.addressId = n;
        this.address = this.addressId > -1 ? (Address)MicroCache.addressBook.elementAt(this.addressId) : new Address();
        this.setCommandListener(this);
        this.addCommand(this.backCommand);
        this.addCommand(this.saveCommand);
        this.addCommand(this.deleteCommand);
        this.displayFields();
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.deleteCommand) {
            if (this.addressId > -1) {
                MicroCache.deleteAddress(this.address, this.addressId);
                this.parent.deleteItem(this.addressId);
            }
        } else if (command == this.saveCommand) {
            this.address.email = this.email.getString();
            this.address.name = this.name.getString();
            MicroCache.storeAddress(this.address, this.addressId);
            if (this.addressId > -1) {
                this.parent.updateItem(this.addressId, this.address.name);
            } else {
                this.parent.appendItem(this.address.name);
            }
        }
        MicroMail.display.setCurrent((Displayable)this.parent);
        MicroMail.dispose((Object)this);
    }

    public void displayFields() {
        String string = "xx";
        String string2 = "xx@xx.xxx";
        if (this.address != null) {
            string = this.address.name;
            string2 = this.address.email;
        }
        this.name = new TextField(Resource.getText(17), string, 20, 0);
        this.email = new TextField(Resource.getText(18), string2, 50, 1);
        this.append((Item)this.name);
        this.append((Item)this.email);
    }
}

