/*
 * Decompiled with CFR 0.152.
 */
package blackjack;

import blackjack.BJ_Alert;
import blackjack.BJ_CardStack;
import blackjack.BJ_Game;
import blackjack.BJ_Help;
import blackjack.BJ_Intro;
import blackjack.BJ_Language;
import blackjack.BJ_Player;
import blackjack.BJ_Text;
import java.util.Random;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.midlet.MIDlet;

public class BlackJack
extends MIDlet {
    public static final boolean debug = false;
    Display display = Display.getDisplay((MIDlet)this);
    Displayable[] screen;
    public static final int PAUSED = 0;
    public static final int INTRO = 1;
    public static final int NEXT_ROUND = 2;
    public static final int PLAYER_MOVE = 3;
    public static final int LANGUAGE = 4;
    public static final int PLAYER_HITS = 5;
    public static final int PLAYER_BUSTED = 6;
    public static final int DEALER_MOVE = 7;
    public static final int PLAYER_WON = 8;
    public static final int DEALER_WON = 9;
    public static final int ROUND_DRAWN = 10;
    public static final int SHUFFLE = 11;
    public static final int HELP = 12;
    public static int STATE = 1;
    private static final int MAX_SCREENS = 15;
    static BJ_Text text;
    protected BJ_Player player;
    protected BJ_Player dealer;
    public static BJ_CardStack cardstack;
    public static int ROUND;
    static int WAIT1;
    static int WAIT2;
    static Random rand;

    public BlackJack() {
        text = new BJ_Text(this);
        this.init_screens();
        this.dealer = new BJ_Player();
        this.player = new BJ_Player();
        cardstack = new BJ_CardStack();
        STATE = 1;
        this.display.setCurrent(this.screen[1]);
    }

    public void init_screens() {
        this.screen = new Displayable[15];
        int n = 2;
        if (this.screen[12] != null) {
            n = ((BJ_Help)this.screen[12]).getNext();
        }
        this.screen[1] = new BJ_Intro(this);
        this.screen[3] = new BJ_Game(this);
        this.screen[4] = new BJ_Language(this);
        this.screen[6] = new BJ_Alert(this, BlackJack.text.Busted);
        this.screen[8] = new BJ_Alert(this, BlackJack.text.Won);
        this.screen[9] = new BJ_Alert(this, BlackJack.text.Lost);
        this.screen[10] = new BJ_Alert(this, BlackJack.text.Drawn);
        this.screen[11] = new BJ_Alert(this, BlackJack.text.Shuffling);
        this.screen[12] = new BJ_Help(this);
        ((BJ_Help)this.screen[12]).setNext(n);
    }

    protected void startApp() {
        if (STATE == 0) {
            STATE = 2;
        }
        while (true) {
            if (STATE == 12) {
                this.display.setCurrent(this.screen[12]);
                while (STATE == 12) {
                }
                this.display.setCurrent(this.screen[STATE]);
            }
            if (STATE == 4) {
                this.display.setCurrent(this.screen[4]);
                while (STATE == 4) {
                }
                this.init_screens();
                this.display.setCurrent(this.screen[STATE]);
            }
            if (STATE == 2) {
                ++ROUND;
                if (BlackJack.cardstack.cards_left < BJ_CardStack.NUMBER_OF_CARDS / 2) {
                    STATE = 11;
                    cardstack.shuffle();
                    this.display.setCurrent(this.screen[11]);
                    while (STATE == 11) {
                    }
                }
                this.dealer.deal2(false);
                this.player.deal2(true);
                STATE = 3;
                this.display.setCurrent(this.screen[STATE]);
            }
            if (STATE == 5) {
                this.player.hit();
                this.display.setCurrent(this.screen[3]);
                STATE = this.player.getPoints() > 21 ? 6 : (this.player.getPoints() == 21 ? 7 : 3);
            }
            if (STATE == 6) {
                this.player.busted();
                try {
                    Thread.sleep(WAIT1);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.display.setCurrent(this.screen[6]);
                while (STATE == 6) {
                }
            }
            if (STATE == 7) {
                this.dealer.card[1].shown = true;
                this.display.setCurrent(this.screen[3]);
                try {
                    Thread.sleep(WAIT2);
                }
                catch (InterruptedException interruptedException) {}
                while (this.dealer.getPoints() < 17) {
                    this.dealer.hit();
                    this.display.setCurrent(this.screen[3]);
                    try {
                        Thread.sleep(WAIT2);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                STATE = this.dealer.getPoints() > 21 || this.dealer.getPoints() < this.player.getPoints() ? 8 : (this.dealer.getPoints() > this.player.getPoints() ? 9 : 10);
            }
            if (STATE == 8) {
                this.player.won();
                try {
                    Thread.sleep(WAIT1);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.display.setCurrent(this.screen[8]);
                while (STATE == 8) {
                }
            }
            if (STATE == 9) {
                this.player.lost();
                try {
                    Thread.sleep(WAIT1);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.display.setCurrent(this.screen[9]);
                while (STATE == 9) {
                }
            }
            if (STATE != 10) continue;
            try {
                Thread.sleep(WAIT1);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.display.setCurrent(this.screen[10]);
            while (STATE == 10) {
            }
        }
    }

    protected void pauseApp() {
        STATE = 0;
    }

    protected void destroyApp(boolean bl) {
        this.display.setCurrent(null);
        this.notifyDestroyed();
    }

    static {
        ROUND = 0;
        WAIT1 = 1500;
        WAIT2 = 800;
        rand = new Random();
    }
}

